<?php

require_once LPC_INCLUDES . 'lpc_modal.php';

class LpcAdminPickupWebService extends LpcComponent {
	protected $ajaxDispatcher;

	public function __construct(
		LpcAjax $ajaxDispatcher = null
	) {
		$this->ajaxDispatcher = LpcRegister::get('ajaxDispatcher', $ajaxDispatcher);
	}

	public function getDependencies() {
		return ['ajaxDispatcher'];
	}

	public function init() {
		$this->ajaxDispatcher->register('pickupWS', array($this, 'pickupWS'));

		$args = [
			'ajaxURL'          => $this->ajaxDispatcher->getUrlForTask('pickupWS'),
		];

		LpcHelper::enqueueScript('lpc_admin_pick_up_ws',
			plugins_url('/js/pickup/admin_pickup_ws.js', LPC_ADMIN . 'init.php'), null,
			['jquery'], 'lpcPickUpWS', $args);
		LpcHelper::enqueueStyle('lpc_admin_pick_up_ws',
			plugins_url('/css/pickup/webservice.css', LPC_ADMIN . 'init.php'), null);
	}

	public function addGoogleMaps(WC_Order $order) {
		$modal = new LpcModal(null, 'Choose a PickUp point', 'lpc_pick_up_web_service');

		$map = LpcHelper::renderPartial(
			'pickup' . DS . 'webservice_map.php',
			[
				'ceAddress'   => !empty($order->get_shipping_address_1()) ? $order->get_shipping_address_1() : '',
				'ceZipCode'   => !empty($order->get_shipping_postcode()) ? $order->get_shipping_postcode() : '',
				'ceTown'      => !empty($order->get_shipping_city()) ? $order->get_shipping_city() : '',
				'ceCountryId' => !empty($order->get_shipping_country()) ? $order->get_shipping_country() : '',
			]
		);

		$modal->setContent($map);

		$args = [
			'modal'  => $modal,
			'apiKey' => LpcHelper::get_option('lpc_gmap_key', ''),
		];

		return LpcHelper::renderPartial('pickup' . DS . 'webservice.php', $args);
	}

	public function pickupWS() {
		require_once LPC_INCLUDES . 'pick_up' . DS . 'lpc_relays_api.php';
		require_once LPC_INCLUDES . 'pick_up' . DS . 'lpc_generate_relays_payload.php';

		$address = array(
			'address'     => LpcHelper::getVar('address'),
			'zipCode'     => LpcHelper::getVar('zipCode'),
			'city'        => LpcHelper::getVar('city'),
			'countryCode' => LpcHelper::getVar('countryId'),
		);

		$generateRelaysPaypload = new LpcGenerateRelaysPayload();

		try {
			$generateRelaysPaypload
				->withLogin()
				->withPassword()
				->withAddress($address)
				->withShippingDate()
				->withOptionInter()
				->checkConsistency();

			$relaysApi = new LpcRelaysApi(['trace' => false]);

			$relaysPayload = $generateRelaysPaypload->assemble();

			$resultWs = $relaysApi->getRelays($relaysPayload);
		} catch (\SoapFault $fault) {
			return $this->ajaxDispatcher->makeAndLogError(['message' => $fault]);
		} catch (Exception $exception) {
			LpcLogger::error($exception);

			return $this->ajaxDispatcher->makeError(['message' => $exception->getMessage()]);
		}

		$return = $resultWs->return;

		if (0 == $return->errorCode) {
			if (empty($return->listePointRetraitAcheminement)) {
				LpcLogger::warn(__('The web service returned 0 relay', 'wc_colissimo'));

				return $this->ajaxDispatcher->makeError(['message' => __('No relay available', 'wc_colissimo')]);
			}

			$listRelaysWS = $return->listePointRetraitAcheminement;
			$html         = '';

			$i           = 0;
			$partialArgs = array(
				'relaysNb'    => count($listRelaysWS),
				'openingDays' => array(
					'Monday'    => 'horairesOuvertureLundi',
					'Tuesday'   => 'horairesOuvertureMardi',
					'Wednesday' => 'horairesOuvertureMercredi',
					'Thursday'  => 'horairesOuvertureJeudi',
					'Friday'    => 'horairesOuvertureVendredi',
					'Saturday'  => 'horairesOuvertureSamedi',
					'Sunday'    => 'horairesOuvertureDimanche',
				),
			);

			foreach ($listRelaysWS as $oneRelay) {
				$partialArgs['oneRelay'] = $oneRelay;
				$partialArgs['i']        = $i++;

				$html .= LpcHelper::renderPartial('pick_up/relay.php', $partialArgs);
			}

            return $this->ajaxDispatcher->makeSuccess(
                [
                    'html' => $html,
                    'chooseRelayText'       => __('Choose this relay', 'wc_colissimo'),
                    'confirmRelayText'      => __('Confirm relay', 'wc_colissimo'),
                    'confirmRelayDescText'  => __('Do you confirm the shipment to this relay:', 'wc_colissimo'),
                ]
            );
		} else {
			if (in_array($return->errorCode, [301, 300, 203])) {
				LpcLogger::warn($return->errorCode . ' : ' . $return->errorMessage);

				return $this->ajaxDispatcher->makeError(['message' => __('No relay available', 'wc_colissimo')]);
			} else {
				// Error codes we want to display the related messages to the client, we'll only display a generic message for the other error codes
				$errorCodesWSClientSide = array(
					'104',
					'105',
					'117',
					'125',
					'129',
					'143',
					'144',
					'145',
					'146',
				);

				if (in_array($return->errorCode, $errorCodesWSClientSide)) {
					return $this->ajaxDispatcher->makeAndLogError(['message' => $return->errorCode . ' : ' . $return->errorMessage]);
				} else {
					LpcLogger::error($return->errorCode . ' : ' . $return->errorMessage);

					return $this->ajaxDispatcher->makeError(['message' => __('Error')]);
				}
			}
		}
	}
}
