<?php


class LpcOrderStatuses extends LpcComponent {
	const WC_LPC_TRANSIT = 'wc-lpc_transit';
	const WC_LPC_DELIVERED = 'wc-lpc_delivered';
	const WC_LPC_ANOMALY = 'wc-lpc_anomaly';
	const WC_LPC_READY_TO_SHIP = 'wc-lpc_ready_to_ship';

	const WC_LPC_DISABLE = 'disable';

	const WC_LPC_UNKNOWN_STATUS_INTERNAL_CODE = -1;

	const WC_LPC_TRANSIT_LABEL = 'Colissimo In-Transit';
	const WC_LPC_DELIVERED_LABEL = 'Colissimo Delivered';
	const WC_LPC_ANOMALY_LABEL = 'Colissimo Anomaly';
	const WC_LPC_READY_TO_SHIP_LABEL = 'Colissimo Ready to ship';

	public function init() {
		add_action('init', array($this, 'register_lpc_post_statuses'));
		add_filter('wc_order_statuses', array($this, 'register_lpc_order_statuses'));
		add_filter('woocommerce_reports_order_statuses', array($this, 'register_reports_lpc_order_statuses'));
	}

	public function register_lpc_order_statuses($order_statuses) {
		$order_statuses[self::WC_LPC_TRANSIT]       = __(self::WC_LPC_TRANSIT_LABEL, 'wc_colissimo');
		$order_statuses[self::WC_LPC_DELIVERED]     = __(self::WC_LPC_DELIVERED_LABEL, 'wc_colissimo');
		$order_statuses[self::WC_LPC_ANOMALY]       = __(self::WC_LPC_ANOMALY_LABEL, 'wc_colissimo');
		$order_statuses[self::WC_LPC_READY_TO_SHIP] = __(self::WC_LPC_READY_TO_SHIP_LABEL, 'wc_colissimo');

		return $order_statuses;
	}

	public function register_lpc_post_statuses() {
		register_post_status(
			self::WC_LPC_TRANSIT,
			array(
				'label'  => __(self::WC_LPC_TRANSIT_LABEL, 'wc_colissimo'),
				'public' => true,
			)
		);
		register_post_status(
			self::WC_LPC_DELIVERED,
			array(
				'label'  => __(self::WC_LPC_DELIVERED_LABEL, 'wc_colissimo'),
				'public' => true,
			)
		);
		register_post_status(
			self::WC_LPC_ANOMALY,
			array(
				'label'  => __(self::WC_LPC_ANOMALY_LABEL, 'wc_colissimo'),
				'public' => true,
			)
		);
		register_post_status(
			self::WC_LPC_READY_TO_SHIP,
			array(
				'label'  => __(self::WC_LPC_READY_TO_SHIP_LABEL, 'wc_colissimo'),
				'public' => true,
			)
		);
	}

	public function register_reports_lpc_order_statuses($paid_order_statuses) {
	    if (!is_array($paid_order_statuses)) {
            $paid_order_statuses = [$paid_order_statuses];
        }

        $paid_order_statuses[] = str_replace('wc-', '', self::WC_LPC_TRANSIT);
        $paid_order_statuses[] = str_replace('wc-', '', self::WC_LPC_DELIVERED);
        $paid_order_statuses[] = str_replace('wc-', '', self::WC_LPC_ANOMALY);
        $paid_order_statuses[] = str_replace('wc-', '', self::WC_LPC_READY_TO_SHIP);

		return $paid_order_statuses;
	}

}
