<?php
namespace Mewz\WCAS\Actions\Admin\Attributes;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Models\AttributeStock;
use Mewz\WCAS\Util\Matches;

class AttributeTermEdit extends Action
{
	public function __hooks()
	{
		add_action($this->context->taxonomy . '_add_form_fields', [$this, 'display_add_term_fields']);
		add_action($this->context->taxonomy . '_edit_form_fields', [$this, 'display_edit_term_fields']);
	}

	public function __scripts()
	{
	    $this->scripts->enqueue_bundle('@admin/attributes');
	}

	public function display_add_term_fields()
	{
		$this->view->render('admin/attributes/add-fields');
	}

	/**
	 * @param \WP_Term $term
	 */
	public function display_edit_term_fields($term = null)
	{
		$stocks = Matches::query_stock($term->taxonomy, $term->term_id, 'edit');

		$this->display_edit_fields($stocks, ['term' => $term]);
	}

	/**
	 * @param AttributeStock[] $stocks
	 * @param array $data
	 */
	public function display_edit_fields($stocks, $data = [])
	{
		if (count($stocks) > 1) {
			$enabled_stocks = [];

			foreach ($stocks as $i => $stock) {
				if ($stock->enabled()) {
					$enabled_stocks[] = $stock;
				}
			}

			if (count($enabled_stocks) !== 1) {
				$data['stocks'] = $stocks;
				$this->view->render('admin/attributes/edit-associated', $data);
				return;
			}

			$stocks = $enabled_stocks;
		}

		$data['stock'] = $stocks ? $stocks[0] : new AttributeStock(null, 'edit');

		$this->view->render('admin/attributes/edit-fields', $data);
	}
}
