<?php
namespace Mewz\WCAS\Actions\Admin\Stock;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Models\AttributeStock;

class StockAjax extends Action
{
	const NS = 'mewz/wcas';
	const BASE = '/stock';

	public function __hooks()
	{
		register_rest_route(self::NS, self::BASE . '/(?P<id>\d+)', [
			'methods' => \WP_REST_Server::EDITABLE,
			'callback' => [$this, 'update_stock'],
			'permission_callback' => [$this, 'permission_check'],
		]);
	}

	public function permission_check(\WP_REST_Request $request)
	{
		$stock = AttributeStock::instance((int)$request->get_param('id'), 'edit');

		if (!$stock->exists()) {
			return new \WP_Error('mewz_wcas_stock_invalid_id', __('Invalid attribute stock ID.', 'woocommerce-attribute-stock'), ['status' => 404]);
		}

		return current_user_can('edit_product', $stock->id());
	}

	public function update_stock(\WP_REST_Request $request)
	{
		$stock = AttributeStock::instance((int)$request->get_param('id'), 'edit');
		$params = $request->get_body_params();

		$stock->bind($params);

		if (!isset($params['quantity']) && isset($params['adjust_quantity'])) {
			$stock->adjust_quantity((float)$params['adjust_quantity']);
		}

		$updated = $stock->save();

		if ($updated === false) {
			return new \WP_Error('mewz_wcas_stock_save_error', $stock->get_error_message());
		}

		if (isset($updated['quantity'])) {
			$updated['formatted_quantity'] = $stock->formatted_quantity();
		}

		return rest_ensure_response($updated);
	}
}
