<?php
namespace Mewz\WCAS\Actions\Front;

use Mewz\Framework\Base\Action;
use Mewz\Framework\Util\WooCommerce;
use Mewz\WCAS\Util;

class ProductQuery extends Action
{
	public static $enabled = true;

	public function __hooks()
	{
		add_action('pre_get_posts', [$this, 'pre_get_posts'], 999);
	}

	public function pre_get_posts(\WP_Query $query)
	{
		if (!self::$enabled || $query->is_singular || !($tax_query = $query->get('tax_query')) || !WooCommerce::hide_out_of_stock()) {
			return;
		}

		foreach ($tax_query as $q) {
			if (isset($q['taxonomy'], $q['terms'], $q['operator']) && $q['taxonomy'] === 'product_visibility' && in_array($q['operator'], ['!=', 'NOT IN'])) {
				$outofstock_term_id = $this->get_oos_term_id();
				if (!$outofstock_term_id) break;

				if ($q['terms'] == $outofstock_term_id || (is_array($q['terms']) && in_array($outofstock_term_id, $q['terms']))) {
					$has_oos_condition = true;
					break;
				}
			}
		}

		if (empty($has_oos_condition)) {
			return;
		}

		self::$enabled = false;
		$product_ids = Util\Matches::get_oos_products();
		self::$enabled = true;

		if ($product_ids) {
			$not_in = $query->get('post__not_in');
			$parent_not_in = $query->get('post_parent__not_in');

			$query->set('post__not_in', $not_in ? array_merge((array)$not_in, $product_ids) : $product_ids);
			$query->set('post_parent__not_in', $parent_not_in ? array_merge((array)$parent_not_in, $product_ids) : $product_ids);
		}
	}

	public function get_oos_term_id()
	{
		static $term_id;

		if ($term_id === null) {
			$term = get_term_by('slug', 'outofstock', 'product_visibility');
			$term_id = $term ? $term->term_id : 0;
		}

		return $term_id;
	}
}
