<?php
defined('WPINC') or die;

/**
 * @var Mewz\Framework\Services\View $this
 * @var Mewz\WCAS\Models\AttributeStock $stock
 * @var bool $attribute_level
 * @var WP_Term $term
 */
?>

<tr class="form-field form-field-mewz-wcas form-field-mewz-wcas-manage-stock">
	<th scope="row">
		<label for="mewz_wcas_manage_stock">
			<?= esc_html__('Manage stock?', 'woocommerce') ?>
		</label>
	</th>
	<td>
		<div class="input-wrap">
			<input type="checkbox" name="mewz_wcas[manage_stock]" id="mewz_wcas_manage_stock" value="1" <?php checked($stock->enabled()) ?>>
			<input type="hidden" name="mewz_wcas[stock_id]" id="mewz_wcas_stock_id" value="<?= $stock->id() ?>">

			<?php if ($stock->exists()): ?>
				<a href="<?= esc_url($stock->edit_url()) ?>" class="button mewz-wcas-edit-button"><?= esc_html__('Configure', 'woocommerce-attribute-stock') ?></span></a>
			<?php endif; ?>
		</div>

		<p class="description">
			<?php if (!empty($attribute_level)): ?>
				<?= esc_html__('Enable stock management at the attribute level.', 'woocommerce-attribute-stock') ?>
			<?php else: ?>
				<?= esc_html__('Enable stock management at the attribute term level.', 'woocommerce-attribute-stock') ?>
			<?php endif; ?>
		</p>
	</td>
</tr>

<tr class="form-field form-field-mewz-wcas form-field-mewz-wcas-sku form-field-mewz-wcas-hidden<?php if ($stock->enabled()) echo ' show'; ?>">
	<th scope="row">
		<label for="mewz_wcas_sku">
			<?= esc_html__('SKU', 'woocommerce') ?>
		</label>
	</th>
	<td>
		<input type="text" name="mewz_wcas[sku]" id="mewz_wcas_sku" value="<?= esc_attr($stock->sku()) ?>">

		<p class="description">
			<?= esc_html__('Unique identifier for stock keeping. Optional.', 'woocommerce-attribute-stock') ?>
		</p>
	</td>
</tr>

<tr class="form-field form-field-mewz-wcas form-field-mewz-wcas-quantity form-field-mewz-wcas-hidden<?php if ($stock->enabled()) echo ' show'; ?>">
	<th scope="row">
		<label for="mewz_wcas_quantity">
			<?= esc_html__('Stock quantity', 'woocommerce') ?>
		</label>
	</th>
	<td>
		<input type="number" name="mewz_wcas[quantity]" id="mewz_wcas_quantity" value="<?= $stock->quantity() ?>" step="any" placeholder="<?= esc_attr(number_format_i18n(0, 2)) ?>">

		<p class="description">
			<?php if (!empty($attribute_level)): ?>
				<?= esc_html__('Current stock quantity of this attribute.', 'woocommerce-attribute-stock') ?>
			<?php else: ?>
				<?= esc_html__('Current stock quantity of this attribute term.', 'woocommerce-attribute-stock') ?>
			<?php endif; ?>
		</p>
	</td>
</tr>
