/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
const $ = jQuery;
const {
  __
} = mewz.i18n;
let $attributesTable, $manageStock, $form; // add stock column to attributes table as early as possible

if (window.hasOwnProperty('mewz_wcas_attributes_table_stock')) {
  $attributesTable = $('.attributes-table');

  if ($attributesTable.length) {
    addAttributesTableStockColumn();
  }
}

jQuery(() => {
  $manageStock = $('#mewz_wcas_manage_stock');
  $form = $manageStock.closest('form');
  $manageStock.on('change', toggleManageStock);
  setTimeout(toggleManageStock);

  if ($form.attr('id') === 'addtag') {
    // WP uses the same "click" listener, and it works for submitting with "enter" too
    $form.find('#submit').on('click', clearAddFieldValues);
  }
});

function toggleManageStock() {
  $('.form-field-mewz-wcas-hidden').toggleClass('show', $manageStock.prop('checked'));
}

function clearAddFieldValues() {
  const $fields = $('.form-field-mewz-wcas-hidden');
  if (!$fields.length) return;
  setTimeout(() => {
    if ($form.find('.form-invalid').length) {
      return;
    }

    $manageStock.prop('checked', false);
    $fields.removeClass('show');
    $fields.find('input').val('');
  });
}

function addAttributesTableStockColumn() {
  if (!window.hasOwnProperty('mewz_wcas_attributes_table_stock')) {
    return;
  }

  const stocks = window.mewz_wcas_attributes_table_stock;
  const $headRow = $attributesTable.find('> thead > tr');
  const $th = $headRow.find('th:first-child').clone().text(__('Stock', 'woocommerce-attribute-stock'));
  $headRow.find('th:nth-child(2)').after($th);
  $attributesTable.find('> tbody > tr').each(function () {
    const $tr = $(this);
    const attrId = parseInt($tr.find('.edit a').attr('href').match(/&edit=(\d+)/)[1]);
    $tr.find('td:nth-child(2)').after($('<td/>').html(stocks[attrId]));
  });
}
})();

// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
// extracted by mini-css-extract-plugin

})();

/******/ })()
;