<?php
/**
 * Ajax methods class.
 *
 * @package Iconic_PC
 */

defined( 'ABSPATH' ) || exit;

/**
 * Iconic_PC_Ajax class.
 */
class Iconic_PC_Ajax {
	/**
	 * Init.
	 */
	public static function run() {
		self::add_ajax_actions();
	}

	/**
	 * Add ajax actions.
	 */
	public static function add_ajax_actions() {
		$ajax_events = array(
			'generate_image'        => true,
			'get_image_layer'       => true,
			'get_conditional_group' => false,
		);

		foreach ( $ajax_events as $ajax_event => $nopriv ) {
			add_action( 'wp_ajax_iconic_pc_' . $ajax_event, array( __CLASS__, $ajax_event ) );

			if ( $nopriv ) {
				add_action( 'wp_ajax_nopriv_iconic_pc_' . $ajax_event, array( __CLASS__, $ajax_event ) );
			}
		}
	}

	/**
	 * Generate final image.
	 */
	public static function generate_image() {
		global $jckpc;

		$params = self::ajax_img_get_params();

		// Set up image space.
		$canvas_width  = $params['images']['background']['full'][1];
		$canvas_height = $params['images']['background']['full'][2];
		$bg            = imagecreatetruecolor( $canvas_width, $canvas_height );

		imagesavealpha( $bg, true );

		$trans_colour = imagecolorallocatealpha( $bg, 0, 0, 0, 127 );
		imagefill( $bg, 0, 0, $trans_colour );

		if ( is_array( $params['images'] ) ) {
			foreach ( $params['images'] as $index => $image_data ) {
				if ( empty( $image_data['path'] ) ) {
					continue;
				}

				$img = imagecreatefrompng( $image_data['path'] );

				imagecopyresized( $bg, $img, 0, 0, 0, 0, $canvas_width, $canvas_height, $canvas_width, $canvas_height );
				imagedestroy( $img );
			}
		}

		header( 'Content-Type: image/png' );
		$final_image = imagepng( $bg, $params['imgData']['finalImgPath'] );

		if ( $final_image ) {
			set_transient( $params['imgData']['imgName'], $params['imgData']['finalImgUrl'], $jckpc->settings['general_cache_duration'] * HOUR_IN_SECONDS );
			imagepng( $bg );
		}

		die;
	}

	/**
	 * Get single image layer.
	 */
	public static function get_image_layer() {
		global $iconic_wpc;

		do_action( 'iconic_pc_before_get_image_layer' );

		$response = array(
			'post'       => $_POST,
			'images'     => array(),
			'request_id' => absint( filter_input( INPUT_POST, 'request_id', FILTER_SANITIZE_NUMBER_INT ) ),
		);

		$product_id          = filter_input( INPUT_POST, 'prodid', FILTER_SANITIZE_NUMBER_INT );
		$selected_attributes = filter_input( INPUT_POST, 'selected_attributes', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY );

		if ( empty( $selected_attributes ) ) {
			wp_send_json_error( $response );
		}

		$response['images'] = $iconic_wpc->get_images_by_attributes( $product_id, $selected_attributes );

		wp_send_json_success( $response );
	}

	/**
	 * Ajax image get params.
	 */
	public static function ajax_img_get_params() {
		global $iconic_wpc;

		$params            = array();
		$attributes        = $iconic_wpc->get_atts_from_querystring();
		$params['images']  = $iconic_wpc->get_images_by_attributes( $_GET['prodid'], $attributes );
		$params['imgData'] = $iconic_wpc->generate_img_paths( $_GET['prodid'], $attributes );

		return $params;
	}

	/**
	 * Get conditional group.
	 */
	public static function get_conditional_group() {
		check_ajax_referer( 'iconic-pc', 'nonce' );

		$data = array(
			'layer_id'     => filter_input( INPUT_POST, 'layer_id', FILTER_SANITIZE_STRING ),
			'product_id'   => absint( filter_input( INPUT_POST, 'product_id', FILTER_SANITIZE_NUMBER_INT ) ),
			'condition_id' => absint( filter_input( INPUT_POST, 'condition_id', FILTER_SANITIZE_NUMBER_INT ) ),
		);

		if ( empty( $data['product_id'] ) ) {
			wp_send_json_error( $data );
		}

		$attributes = Iconic_PC_Product::get_attributes( $data['product_id'] );

		ob_start();
		Iconic_PC_Templates::conditional_layer( $data['layer_id'], $attributes, null, $data['condition_id'] );
		$data['html'] = ob_get_clean();

		wp_send_json_success( $data );
	}
}
