<?php
namespace Mewz\WCAS\Actions\Admin\Attributes;

use Mewz\Framework\Base\Action;
use Mewz\Framework\Util\Number;
use Mewz\WCAS\Models\AttributeStock;
use Mewz\WCAS\Util\Attributes;
use Mewz\WCAS\Util\Matches;

class AttributeList extends Action
{
	public function __hooks()
	{
	    add_action('admin_print_footer_scripts', [$this, 'export_js_stock_columns'], 0);
	}

	public function __scripts()
	{
		$this->scripts->enqueue_bundle('@admin/attributes');
	}

	public function export_js_stock_columns()
	{
		$attributes = Attributes::get_attributes();
		if (!$attributes) return;

		$stock_columns = [];

		foreach ($attributes as $attribute_id => $attribute) {
			$stock_columns[$attribute_id] = $this->get_stock_column_output($attribute_id);
		}

		$this->scripts->export_js('@admin/attributes', 'mewz_wcas_attributes_table_stock', $stock_columns);
	}

	public function get_stock_column_output($attribute_id)
	{
		$stock_ids = Matches::query_stock($attribute_id, null, 'view', 'id');
		$stock_count = count($stock_ids);
		$output = '';

		if ($stock_count === 1) {
			$stock = AttributeStock::instance($stock_ids[0]);
			$edit_url = $stock->edit_url(['_wp_http_referer' => urlencode($_SERVER['REQUEST_URI'])]);

			$output = '<a href="' . esc_url($edit_url) . '" class="mewz-wcas-stock-link" title="' . esc_attr__('Edit stock', 'woocommerce-attribute-stock') . '">' . Number::local_format($stock->quantity()) . '</a>';
		}
		elseif ($stock_count > 1) {
			$qty_range = Matches::get_quantity_range($stock_ids, $attribute_id);
			$url = admin_url('edit.php?post_type=mewz_attribute_stock&attribute_level=' . $attribute_id);

			$output = '<a href="' . esc_url($url) . '" class="mewz-wcas-stock-link mewz-wcas-stock-range" title="' . esc_attr__('List stock items', 'woocommerce-attribute-stock') . '">' . $qty_range . '</a>';
		}

		return $output;
	}
}
