<?php
namespace Mewz\WCAS\Actions\Admin\Products;

use Mewz\Framework\Base\Action;

class ProductOptions extends Action
{
	public function __hooks()
	{
		add_action('woocommerce_product_options_sold_individually', [$this, 'display_options']);
		add_action('woocommerce_admin_process_product_object', [$this, 'process_options']);
	}

	public function display_options()
	{
		global $product_object;

		woocommerce_wp_checkbox([
			'id'          => '_mewz_wcas_exclude',
			'value'       => (int)$product_object->get_meta('_mewz_wcas_exclude'),
			'cbvalue'     => 1,
			'label'       => __('Ignore attribute stock', 'woocommerce-attribute-stock'),
			'description' => __('Exclude this product from affecting or being affected by attribute stock', 'woocommerce-attribute-stock'),
		]);
	}

	public function process_options(\WC_Product $product)
	{
		if (!empty($_POST['_mewz_wcas_exclude'])) {
			$product->update_meta_data('_mewz_wcas_exclude', 1);
		} else {
			$product->delete_meta_data('_mewz_wcas_exclude');
		}
	}
}
