<?php
namespace Mewz\WCAS\Actions\Admin\Products;

use Mewz\Framework\Base\Action;

class ProductVariationOptions extends Action
{
	public function __hooks()
	{
		add_action('woocommerce_variation_options', [$this, 'variation_options'], 10, 3);
		add_action('woocommerce_save_product_variation', [$this, 'save_product_variation'], 10, 2);
	}

	public function variation_options($i, $data, $post)
	{
	  if (!$post || empty($post->ID)) {
	    return;
	  }

		$variation = wc_get_product($post->ID);
		if (!$variation) return;

		?><label class="tips" data-tip="<?= esc_attr__('Exclude this variation from affecting or being affected by attribute stock', 'woocommerce-attribute-stock') ?>">
			<?= esc_html__('Ignore attribute stock', 'woocommerce-attribute-stock') ?>
			<input type="checkbox" class="checkbox variable_mewz_wcas_exclude" name="variable_mewz_wcas_exclude[<?= esc_attr($i) ?>]" <?php checked($variation->get_meta('_mewz_wcas_exclude')) ?> />
		</label><?php
	}

	public function save_product_variation($variation_id, $i)
	{
	  if (!$variation_id) return;

		$variation = wc_get_product($variation_id);
	  if (!$variation) return;

		if (!empty($_POST['variable_mewz_wcas_exclude'][$i])) {
			$variation->update_meta_data('_mewz_wcas_exclude', 1);
		} else {
			$variation->delete_meta_data('_mewz_wcas_exclude');
		}

		$variation->save_meta_data();
	}
}
