<?php
namespace Mewz\WCAS\Actions\Common;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util\Compatibility;
use Mewz\WCAS\Util\Matches;

class DeleteMatches extends Action
{
	public function __hooks()
	{
		add_action('woocommerce_attribute_deleted', [$this, 'deleted_attribute']);
		add_action('delete_term', [$this, 'delete_term'], 10, 3);
		add_action('delete_post', [$this, 'delete_post']);
	}

	public function deleted_attribute($attribute_id)
	{
		Matches::delete_rows($attribute_id, null, true);
		Matches::delete_empty_attribute_level_stocks($attribute_id);
	}

	public function delete_term($term_id, $tt_id, $taxonomy)
	{
		if (strpos($taxonomy, 'pa_') !== 0) return;

		Compatibility::safe_post_type([Matches::class, 'delete_rows'], $taxonomy, $term_id);
	}

	public function delete_post($post_id)
	{
		if (get_post_type($post_id) === 'mewz_attribute_stock') {
			Matches::delete_sets($post_id);
		}
	}
}
