<?php
namespace Mewz\WCAS\Compatibility\Actions;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Models\AttributeStock;

class WPRocket extends Action
{
	public function __hooks()
	{
		add_action('mewz_wcas_stock_change', [$this, 'stock_change']);
	}

	public function stock_change($stock_ids)
	{
		// updating an attribute stock item could potentially affect every product and/or page
		// on the site, so we need to clear all cache whenever any active stock item changes
		foreach ($stock_ids as $stock_id) {
			$stock = AttributeStock::instance($stock_id);

			if ($stock->exists() && $stock->enabled() && $stock->limit_products()) {
				add_action('shutdown', 'rocket_clean_domain');
				break;
			}
		}
	}
}
