<?php
namespace Mewz\WCAS\Compatibility\Actions;

use Mewz\Framework\Base\Action;
use Mewz\Framework\Compatibility\Multilang;
use Mewz\WCAS\Util\Products;

class WooCommerce extends Action
{
	public function __hooks()
	{
		// product search multilang compatibility
		add_action('wp_ajax_woocommerce_json_search_products', [$this, 'ajax_before_json_search_products'], 0);
		add_action('wp_ajax_woocommerce_json_search_products_and_variations', [$this, 'ajax_before_json_search_products'], 0);

		// fix product search field variation formatting (see https://github.com/woocommerce/woocommerce/issues/27154)
		//add_filter('woocommerce_json_search_found_products', [$this, 'json_search_found_products'], 5);

		// ensure product limiting doesn't override product props in places where edit context should *always* be used
		add_filter('mewz_wcas_limit_product_stock', [$this, 'limit_product_stock'], 999999);
	}

	public function ajax_before_json_search_products()
	{
		if (Multilang::active() && $this->check_referrer()) {
			Multilang::set_lang(Multilang::get_lang('default'));
		}
	}

	public function json_search_found_products($results)
	{
		if ($this->check_referrer()) {
			foreach ($results as $product_id => &$label) {
				$label = Products::get_formatted_product_name(wc_get_product($product_id));
			}
		}

		return $results;
	}

	public function check_referrer()
	{
		// make sure we only modify the results for our own edit pages
		$referer = wp_get_raw_referer();

		if (strpos($referer, '/post.php') !== false) {
			return (
				preg_match('/[?&]post=(\d+)/', $referer, $matches)
				&& !empty($matches[1])
				&& get_post_type((int)$matches[1]) === 'mewz_attribute_stock'
			);
		} else {
			return (
				strpos($referer, '/post-new.php') !== false
				&& strpos($referer, 'post_type=mewz_attribute_stock') !== false
			);
		}
	}

	public function limit_product_stock($limit)
	{
		global $pagenow;

		if ($limit) {
			// don't limit on the product edit page
			if ($pagenow == 'post.php' && !empty($_GET['post']) && get_post_type($_GET['post']) === 'product') {
				return false;
			}

			// don't limit during variation ajax actions
			if ($this->context->ajax && isset($_REQUEST['action']) && in_array($_REQUEST['action'], ['woocommerce_add_variation', 'woocommerce_save_variations', 'woocommerce_load_variations'])) {
				return false;
			}
		}

		return $limit;
	}
}
