<?php

use Mewz\Framework\Util\Number;
use Mewz\WCAS\Util\Matches;

defined('WPINC') or die;

/**
 * @var Mewz\Framework\Services\View $this
 * @var Mewz\WCAS\Models\AttributeStock[] $stocks
 * @var WP_Term $term
 */
?>

<tr class="form-field form-field-mewz-wcas-associated">
	<th scope="row">
		<label for="mewz_wcas_assigned">
			<?= esc_html__('Associated stock', 'woocommerce-attribute-stock') ?>
		</label>
	</th>
	<td>
		<table class="mewz-wcas-associated-table widefat fixed striped">
			<thead>
				<tr>
					<th scope="col" class="column-title"><?= esc_html__('Title') ?></th>
					<th scope="col" class="column-sku"><?= esc_html__('SKU', 'woocommerce') ?></th>
					<th scope="col" class="column-quantity"><?= esc_html__('Stock', 'woocommerce') ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($stocks as $stock): ?>
					<tr>
						<td class="column-title">
							<a href="<?= esc_url($stock->edit_url()) ?>" class="stock-title-link"><?= esc_html($stock->title()) ?></a>

							<?php if (!$stock->enabled()): ?>
								<span class="disabled-status">— <?= esc_html__('Disabled', 'woocommerce-attribute-stock') ?></span>
							<?php endif; ?>
						</td>

						<td class="column-sku">
							<?= esc_html($stock->sku()) ?>
						</td>

						<td class="column-quantity">
							<?php if ($term): ?>
								<?= Matches::get_term_display_quantity($stock, $term->taxonomy, $term->term_id) ?>
							<?php else: ?>
								<?= Number::local_format($stock->quantity()) ?>
							<?php endif; ?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</td>
</tr>
