<?php
/**
 * Plugin Name: WooCommerce Attribute Stock
 * Plugin URI:  https://codecanyon.net/item/woocommerce-attribute-stock/25796765
 * Description: Share stock between multiple products or variations. Easily track shared stock, variable stock, product addons, ingredients, and more!
 * Version:     1.7.9
 * Author:      Mewz
 * Author URI:  https://mewz.dev/
 *
 * Text Domain: woocommerce-attribute-stock
 * Domain Path: /languages
 *
 * Requires at least: 4.7
 * Requires PHP: 5.6
 * WC requires at least: 3.5
 * WC tested up to: 6.5
 */

defined('ABSPATH') or die;

if (defined('MEWZ_WCAS_VERSION')) {
	die(sprintf(__('A different version of %s is already installed. Please deactivate and uninstall it first. Your attribute stock data will not be deleted.', 'woocommerce-attribute-stock'), '<strong>' . MEWZ_WCAS_NAME . '</strong>'));
}

const MEWZ_WCAS_VERSION = '1.7.9';
const MEWZ_WCAS_NAME = 'WooCommerce Attribute Stock';
const MEWZ_WCAS_DOMAIN = 'woocommerce-attribute-stock';
const MEWZ_WCAS_PREFIX = 'mewz_wcas';

const MEWZ_WCAS_LITE = false;
const MEWZ_WCAS_WPORG_SLUG = 'attribute-stock-for-woocommerce';
const MEWZ_WCAS_ENVATO_ID = 25796765;

const MEWZ_WCAS_FILE = __FILE__;
const MEWZ_WCAS_DIR = __DIR__;

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/includes/functions.php';

Mewz\WCAS\Plugin::run();
