<?php
namespace Mewz\WCAS\Actions\Front;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util\Cart;

class CartItems extends Action
{
	public $error_count = 0;

	public function __hooks()
	{
		add_filter('woocommerce_cart_contents_changed', [$this, 'cart_contents_changed'], 5);

		add_action('woocommerce_check_cart_items', [$this, 'check_cart_items_before'], 0);
		add_action('woocommerce_check_cart_items', [$this, 'check_cart_items_after'], 2);
	}

	public function cart_contents_changed($cart_contents)
	{
		foreach ($cart_contents as $item) {
			Cart::set_item_product_variation_data($item);
		}

		return $cart_contents;
	}

	public function check_cart_items_before()
	{
		// don't check attribute stock if checking cart items has been disabled
		if (!has_action('woocommerce_check_cart_items', [WC()->cart, 'check_cart_items'])) {
			return;
		}

		// first check product stock without any attribute stock applied
		ProductLimits::$enabled = false;

		// save current error count so we can check if there are any product stock errors in the next step
		$this->error_count = wc_notice_count('error');
	}

	public function check_cart_items_after()
	{
		if (ProductLimits::$enabled || wc_notice_count('error') > $this->error_count) {
			return;
		}

		// re-enable attribute stock limits for the following stock checks
		ProductLimits::$enabled = true;

		// check stock of individual items, with attribute stock applied,
		// but without taking into account other items in the cart
		if (is_wp_error($result = Cart::check_individual_items_stock())) {
			wc_add_notice($result->get_error_message(), 'error');
			return;
		}

		// check that there is enough attribute stock between all items in the cart
		if (is_wp_error($result = Cart::check_shared_attribute_stock())) {
			wc_add_notice($result->get_error_message(), 'error');
			return;
		}
	}
}
