<?php

class Customify_Font_Icons
{
	static $_instance;
	static $_icons;
	static $enqueued;
	private $picked_types = array();

	static function get_instance()
	{
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Get support icons
	 *
	 * @return array
	 */
	function get_icons()
	{
		if (is_null(self::$_icons)) {
			$ver = get_option('customify_fa_ver', 'v4');

			$icons = [];
			if ('v4' ==  $ver) {
				$icons['font-awesome'] = array(
					'name'         => __('Font Awesome v4', 'customify'),
					'icons'        => $this->get_font_awesome_icons(),
					'url'          => esc_url(get_template_directory_uri()) . '/assets/fonts/font-awesome/css/font-awesome.min.css',
					'class_config' => '__icon_name__', // __icon_name__ will replace by icon class name
				);
			}
			/**
			 * @since 0.3.9
			 */
			if ('v6' ==  $ver) {
				$icons['font-awesome-v6'] = array(
					'name'         => __('Font Awesome v6', 'customify'),
					'icons'        => $this->get_font_awesome_icons6(),
					'url'          => esc_url(get_template_directory_uri()) . '/assets/fonts/fontawesome-v6/css/all.min.css',
					'class_config' => '__icon_name__', // __icon_name__ will replace by icon class name
				);
			}
			/**
			 * @since 0.3.9
			 */
			if ('v456' ==  $ver) {
				$icons['font-awesome-v456'] = array(
					'name'         => __('Font Awesome v6', 'customify'),
					'icons'        => $this->get_font_awesome_icons6(),
					'url'          => array(
						'font-awesome-v6' => esc_url(get_template_directory_uri()) . '/assets/fonts/fontawesome-v6/css/all.min.css',
						'font-awesome-4-shim' => esc_url(get_template_directory_uri()) . '/assets/fonts/fontawesome-v6/css/v4-shims.min.css',
					),
					'class_config' => '__icon_name__', // __icon_name__ will replace by icon class name
				);
			}

			self::$_icons = apply_filters('customify/customizer/font_icons', $icons);
		}

		return self::$_icons;
	}

	function is_used()
	{
		if (is_customize_preview()) {
			return true;
		}
		$check = apply_filters('customify/load-icons', true);
		if (is_null($check)) {
			$builders = array('header_builder_panel', 'footer_builder_panel');
			$list     = apply_filters('customify/icon_used', array());

			foreach ($builders as $setting_key) {
				$data = Customify()->get_setting($setting_key);
				if (is_array($data)) {
					foreach ($data as $devices => $rows) {
						foreach ((array) $rows as $row_id => $items) {
							foreach ((array) $items as $item) {
								if (is_array($item)) {
									if (isset($list[$item['id']]) && $list[$item['id']]) {
										return true;
									}
								}
							}
						}
					}
				}
			}
		}

		return $check;
	}

	function enqueue()
	{
		if ($this->is_used()) {
			if (is_null(self::$enqueued)) {
				/**
				 * @since 0.3.9
				 */
				wp_dequeue_style('awf-fontawesome');
				foreach ($this->get_icons() as $icon_id => $icon) {
					if (!is_array($icon['url'])) {
						wp_register_style($icon_id, $icon['url'], array(), '5.0.0');
						wp_enqueue_style($icon_id);
					} else {
						foreach ($icon['url'] as $id => $url) {
							wp_register_style($id, $url, array(), '5.0.0');
							wp_enqueue_style($id);
						}
					}
				}
				self::$enqueued = true;
			}

			/**
			 *
			 */
			if (did_action('elementor/loaded')) {
				$load_shim = get_option('elementor_load_fa4_shim', false);
				if ('yes' != $load_shim) {
					update_option('elementor_load_fa4_shim', 'yes');
				}
			}
		}
	}

	/**
	 * Get FontAwesome icons
	 *
	 * @version 5
	 *
	 * @return array
	 */
	function get_font_awesome_icons()
	{
		$icons =
			array(
				0 => 'fa fa-glass',
				1 => 'fa fa-music',
				2 => 'fa fa-search',
				3 => 'fa fa-envelope-o',
				4 => 'fa fa-heart',
				5 => 'fa fa-star',
				6 => 'fa fa-star-o',
				7 => 'fa fa-user',
				8 => 'fa fa-film',
				9 => 'fa fa-th-large',
				10 => 'fa fa-th',
				11 => 'fa fa-th-list',
				12 => 'fa fa-check',
				13 => 'fa fa-remove',
				14 => 'fa fa-close',
				15 => 'fa fa-times',
				16 => 'fa fa-search-plus',
				17 => 'fa fa-search-minus',
				18 => 'fa fa-power-off',
				19 => 'fa fa-signal',
				20 => 'fa fa-gear',
				21 => 'fa fa-cog',
				22 => 'fa fa-trash-o',
				23 => 'fa fa-home',
				24 => 'fa fa-file-o',
				25 => 'fa fa-clock-o',
				26 => 'fa fa-road',
				27 => 'fa fa-download',
				28 => 'fa fa-arrow-circle-o-down',
				29 => 'fa fa-arrow-circle-o-up',
				30 => 'fa fa-inbox',
				31 => 'fa fa-play-circle-o',
				32 => 'fa fa-rotate-right',
				33 => 'fa fa-repeat',
				34 => 'fa fa-refresh',
				35 => 'fa fa-list-alt',
				36 => 'fa fa-lock',
				37 => 'fa fa-flag',
				38 => 'fa fa-headphones',
				39 => 'fa fa-volume-off',
				40 => 'fa fa-volume-down',
				41 => 'fa fa-volume-up',
				42 => 'fa fa-qrcode',
				43 => 'fa fa-barcode',
				44 => 'fa fa-tag',
				45 => 'fa fa-tags',
				46 => 'fa fa-book',
				47 => 'fa fa-bookmark',
				48 => 'fa fa-print',
				49 => 'fa fa-camera',
				50 => 'fa fa-font',
				51 => 'fa fa-bold',
				52 => 'fa fa-italic',
				53 => 'fa fa-text-height',
				54 => 'fa fa-text-width',
				55 => 'fa fa-align-left',
				56 => 'fa fa-align-center',
				57 => 'fa fa-align-right',
				58 => 'fa fa-align-justify',
				59 => 'fa fa-list',
				60 => 'fa fa-dedent',
				61 => 'fa fa-outdent',
				62 => 'fa fa-indent',
				63 => 'fa fa-video-camera',
				64 => 'fa fa-photo',
				65 => 'fa fa-image',
				66 => 'fa fa-picture-o',
				67 => 'fa fa-pencil',
				68 => 'fa fa-map-marker',
				69 => 'fa fa-adjust',
				70 => 'fa fa-tint',
				71 => 'fa fa-edit',
				72 => 'fa fa-pencil-square-o',
				73 => 'fa fa-share-square-o',
				74 => 'fa fa-check-square-o',
				75 => 'fa fa-arrows',
				76 => 'fa fa-step-backward',
				77 => 'fa fa-fast-backward',
				78 => 'fa fa-backward',
				79 => 'fa fa-play',
				80 => 'fa fa-pause',
				81 => 'fa fa-stop',
				82 => 'fa fa-forward',
				83 => 'fa fa-fast-forward',
				84 => 'fa fa-step-forward',
				85 => 'fa fa-eject',
				86 => 'fa fa-chevron-left',
				87 => 'fa fa-chevron-right',
				88 => 'fa fa-plus-circle',
				89 => 'fa fa-minus-circle',
				90 => 'fa fa-times-circle',
				91 => 'fa fa-check-circle',
				92 => 'fa fa-question-circle',
				93 => 'fa fa-info-circle',
				94 => 'fa fa-crosshairs',
				95 => 'fa fa-times-circle-o',
				96 => 'fa fa-check-circle-o',
				97 => 'fa fa-ban',
				98 => 'fa fa-arrow-left',
				99 => 'fa fa-arrow-right',
				100 => 'fa fa-arrow-up',
				101 => 'fa fa-arrow-down',
				102 => 'fa fa-mail-forward',
				103 => 'fa fa-share',
				104 => 'fa fa-expand',
				105 => 'fa fa-compress',
				106 => 'fa fa-plus',
				107 => 'fa fa-minus',
				108 => 'fa fa-asterisk',
				109 => 'fa fa-exclamation-circle',
				110 => 'fa fa-gift',
				111 => 'fa fa-leaf',
				112 => 'fa fa-fire',
				113 => 'fa fa-eye',
				114 => 'fa fa-eye-slash',
				115 => 'fa fa-warning',
				116 => 'fa fa-exclamation-triangle',
				117 => 'fa fa-plane',
				118 => 'fa fa-calendar',
				119 => 'fa fa-random',
				120 => 'fa fa-comment',
				121 => 'fa fa-magnet',
				122 => 'fa fa-chevron-up',
				123 => 'fa fa-chevron-down',
				124 => 'fa fa-retweet',
				125 => 'fa fa-shopping-cart',
				126 => 'fa fa-folder',
				127 => 'fa fa-folder-open',
				128 => 'fa fa-arrows-v',
				129 => 'fa fa-arrows-h',
				130 => 'fa fa-bar-chart-o',
				131 => 'fa fa-bar-chart',
				132 => 'fa fa-twitter-square',
				133 => 'fa fa-facebook-square',
				134 => 'fa fa-camera-retro',
				135 => 'fa fa-key',
				136 => 'fa fa-gears',
				137 => 'fa fa-cogs',
				138 => 'fa fa-comments',
				139 => 'fa fa-thumbs-o-up',
				140 => 'fa fa-thumbs-o-down',
				141 => 'fa fa-star-half',
				142 => 'fa fa-heart-o',
				143 => 'fa fa-sign-out',
				144 => 'fa fa-linkedin-square',
				145 => 'fa fa-thumb-tack',
				146 => 'fa fa-external-link',
				147 => 'fa fa-sign-in',
				148 => 'fa fa-trophy',
				149 => 'fa fa-github-square',
				150 => 'fa fa-upload',
				151 => 'fa fa-lemon-o',
				152 => 'fa fa-phone',
				153 => 'fa fa-square-o',
				154 => 'fa fa-bookmark-o',
				155 => 'fa fa-phone-square',
				156 => 'fa fa-twitter',
				157 => 'fa fa-facebook-f',
				158 => 'fa fa-facebook',
				159 => 'fa fa-github',
				160 => 'fa fa-unlock',
				161 => 'fa fa-credit-card',
				162 => 'fa fa-feed',
				163 => 'fa fa-rss',
				164 => 'fa fa-hdd-o',
				165 => 'fa fa-bullhorn',
				166 => 'fa fa-bell',
				167 => 'fa fa-certificate',
				168 => 'fa fa-hand-o-right',
				169 => 'fa fa-hand-o-left',
				170 => 'fa fa-hand-o-up',
				171 => 'fa fa-hand-o-down',
				172 => 'fa fa-arrow-circle-left',
				173 => 'fa fa-arrow-circle-right',
				174 => 'fa fa-arrow-circle-up',
				175 => 'fa fa-arrow-circle-down',
				176 => 'fa fa-globe',
				177 => 'fa fa-wrench',
				178 => 'fa fa-tasks',
				179 => 'fa fa-filter',
				180 => 'fa fa-briefcase',
				181 => 'fa fa-arrows-alt',
				182 => 'fa fa-group',
				183 => 'fa fa-users',
				184 => 'fa fa-chain',
				185 => 'fa fa-link',
				186 => 'fa fa-cloud',
				187 => 'fa fa-flask',
				188 => 'fa fa-cut',
				189 => 'fa fa-scissors',
				190 => 'fa fa-copy',
				191 => 'fa fa-files-o',
				192 => 'fa fa-paperclip',
				193 => 'fa fa-save',
				194 => 'fa fa-floppy-o',
				195 => 'fa fa-square',
				196 => 'fa fa-navicon',
				197 => 'fa fa-reorder',
				198 => 'fa fa-bars',
				199 => 'fa fa-list-ul',
				200 => 'fa fa-list-ol',
				201 => 'fa fa-strikethrough',
				202 => 'fa fa-underline',
				203 => 'fa fa-table',
				204 => 'fa fa-magic',
				205 => 'fa fa-truck',
				206 => 'fa fa-pinterest',
				207 => 'fa fa-pinterest-square',
				208 => 'fa fa-google-plus-square',
				209 => 'fa fa-google-plus',
				210 => 'fa fa-money',
				211 => 'fa fa-caret-down',
				212 => 'fa fa-caret-up',
				213 => 'fa fa-caret-left',
				214 => 'fa fa-caret-right',
				215 => 'fa fa-columns',
				216 => 'fa fa-unsorted',
				217 => 'fa fa-sort',
				218 => 'fa fa-sort-down',
				219 => 'fa fa-sort-desc',
				220 => 'fa fa-sort-up',
				221 => 'fa fa-sort-asc',
				222 => 'fa fa-envelope',
				223 => 'fa fa-linkedin',
				224 => 'fa fa-rotate-left',
				225 => 'fa fa-undo',
				226 => 'fa fa-legal',
				227 => 'fa fa-gavel',
				228 => 'fa fa-dashboard',
				229 => 'fa fa-tachometer',
				230 => 'fa fa-comment-o',
				231 => 'fa fa-comments-o',
				232 => 'fa fa-flash',
				233 => 'fa fa-bolt',
				234 => 'fa fa-sitemap',
				235 => 'fa fa-umbrella',
				236 => 'fa fa-paste',
				237 => 'fa fa-clipboard',
				238 => 'fa fa-lightbulb-o',
				239 => 'fa fa-exchange',
				240 => 'fa fa-cloud-download',
				241 => 'fa fa-cloud-upload',
				242 => 'fa fa-user-md',
				243 => 'fa fa-stethoscope',
				244 => 'fa fa-suitcase',
				245 => 'fa fa-bell-o',
				246 => 'fa fa-coffee',
				247 => 'fa fa-cutlery',
				248 => 'fa fa-file-text-o',
				249 => 'fa fa-building-o',
				250 => 'fa fa-hospital-o',
				251 => 'fa fa-ambulance',
				252 => 'fa fa-medkit',
				253 => 'fa fa-fighter-jet',
				254 => 'fa fa-beer',
				255 => 'fa fa-h-square',
				256 => 'fa fa-plus-square',
				257 => 'fa fa-angle-double-left',
				258 => 'fa fa-angle-double-right',
				259 => 'fa fa-angle-double-up',
				260 => 'fa fa-angle-double-down',
				261 => 'fa fa-angle-left',
				262 => 'fa fa-angle-right',
				263 => 'fa fa-angle-up',
				264 => 'fa fa-angle-down',
				265 => 'fa fa-desktop',
				266 => 'fa fa-laptop',
				267 => 'fa fa-tablet',
				268 => 'fa fa-mobile-phone',
				269 => 'fa fa-mobile',
				270 => 'fa fa-circle-o',
				271 => 'fa fa-quote-left',
				272 => 'fa fa-quote-right',
				273 => 'fa fa-spinner',
				274 => 'fa fa-circle',
				275 => 'fa fa-mail-reply',
				276 => 'fa fa-reply',
				277 => 'fa fa-github-alt',
				278 => 'fa fa-folder-o',
				279 => 'fa fa-folder-open-o',
				280 => 'fa fa-smile-o',
				281 => 'fa fa-frown-o',
				282 => 'fa fa-meh-o',
				283 => 'fa fa-gamepad',
				284 => 'fa fa-keyboard-o',
				285 => 'fa fa-flag-o',
				286 => 'fa fa-flag-checkered',
				287 => 'fa fa-terminal',
				288 => 'fa fa-code',
				289 => 'fa fa-mail-reply-all',
				290 => 'fa fa-reply-all',
				291 => 'fa fa-star-half-empty',
				292 => 'fa fa-star-half-full',
				293 => 'fa fa-star-half-o',
				294 => 'fa fa-location-arrow',
				295 => 'fa fa-crop',
				296 => 'fa fa-code-fork',
				297 => 'fa fa-unlink',
				298 => 'fa fa-chain-broken',
				299 => 'fa fa-question',
				300 => 'fa fa-info',
				301 => 'fa fa-exclamation',
				302 => 'fa fa-superscript',
				303 => 'fa fa-subscript',
				304 => 'fa fa-eraser',
				305 => 'fa fa-puzzle-piece',
				306 => 'fa fa-microphone',
				307 => 'fa fa-microphone-slash',
				308 => 'fa fa-shield',
				309 => 'fa fa-calendar-o',
				310 => 'fa fa-fire-extinguisher',
				311 => 'fa fa-rocket',
				312 => 'fa fa-maxcdn',
				313 => 'fa fa-chevron-circle-left',
				314 => 'fa fa-chevron-circle-right',
				315 => 'fa fa-chevron-circle-up',
				316 => 'fa fa-chevron-circle-down',
				317 => 'fa fa-html5',
				318 => 'fa fa-css3',
				319 => 'fa fa-anchor',
				320 => 'fa fa-unlock-alt',
				321 => 'fa fa-bullseye',
				322 => 'fa fa-ellipsis-h',
				323 => 'fa fa-ellipsis-v',
				324 => 'fa fa-rss-square',
				325 => 'fa fa-play-circle',
				326 => 'fa fa-ticket',
				327 => 'fa fa-minus-square',
				328 => 'fa fa-minus-square-o',
				329 => 'fa fa-level-up',
				330 => 'fa fa-level-down',
				331 => 'fa fa-check-square',
				332 => 'fa fa-pencil-square',
				333 => 'fa fa-external-link-square',
				334 => 'fa fa-share-square',
				335 => 'fa fa-compass',
				336 => 'fa fa-toggle-down',
				337 => 'fa fa-caret-square-o-down',
				338 => 'fa fa-toggle-up',
				339 => 'fa fa-caret-square-o-up',
				340 => 'fa fa-toggle-right',
				341 => 'fa fa-caret-square-o-right',
				342 => 'fa fa-euro',
				343 => 'fa fa-eur',
				344 => 'fa fa-gbp',
				345 => 'fa fa-dollar',
				346 => 'fa fa-usd',
				347 => 'fa fa-rupee',
				348 => 'fa fa-inr',
				349 => 'fa fa-cny',
				350 => 'fa fa-rmb',
				351 => 'fa fa-yen',
				352 => 'fa fa-jpy',
				353 => 'fa fa-ruble',
				354 => 'fa fa-rouble',
				355 => 'fa fa-rub',
				356 => 'fa fa-won',
				357 => 'fa fa-krw',
				358 => 'fa fa-bitcoin',
				359 => 'fa fa-btc',
				360 => 'fa fa-file',
				361 => 'fa fa-file-text',
				362 => 'fa fa-sort-alpha-asc',
				363 => 'fa fa-sort-alpha-desc',
				364 => 'fa fa-sort-amount-asc',
				365 => 'fa fa-sort-amount-desc',
				366 => 'fa fa-sort-numeric-asc',
				367 => 'fa fa-sort-numeric-desc',
				368 => 'fa fa-thumbs-up',
				369 => 'fa fa-thumbs-down',
				370 => 'fa fa-youtube-square',
				371 => 'fa fa-youtube',
				372 => 'fa fa-xing',
				373 => 'fa fa-xing-square',
				374 => 'fa fa-youtube-play',
				375 => 'fa fa-dropbox',
				376 => 'fa fa-stack-overflow',
				377 => 'fa fa-instagram',
				378 => 'fa fa-flickr',
				379 => 'fa fa-adn',
				380 => 'fa fa-bitbucket',
				381 => 'fa fa-bitbucket-square',
				382 => 'fa fa-tumblr',
				383 => 'fa fa-tumblr-square',
				384 => 'fa fa-long-arrow-down',
				385 => 'fa fa-long-arrow-up',
				386 => 'fa fa-long-arrow-left',
				387 => 'fa fa-long-arrow-right',
				388 => 'fa fa-apple',
				389 => 'fa fa-windows',
				390 => 'fa fa-android',
				391 => 'fa fa-linux',
				392 => 'fa fa-dribbble',
				393 => 'fa fa-skype',
				394 => 'fa fa-foursquare',
				395 => 'fa fa-trello',
				396 => 'fa fa-female',
				397 => 'fa fa-male',
				398 => 'fa fa-gittip',
				399 => 'fa fa-gratipay',
				400 => 'fa fa-sun-o',
				401 => 'fa fa-moon-o',
				402 => 'fa fa-archive',
				403 => 'fa fa-bug',
				404 => 'fa fa-vk',
				405 => 'fa fa-weibo',
				406 => 'fa fa-renren',
				407 => 'fa fa-pagelines',
				408 => 'fa fa-stack-exchange',
				409 => 'fa fa-arrow-circle-o-right',
				410 => 'fa fa-arrow-circle-o-left',
				411 => 'fa fa-toggle-left',
				412 => 'fa fa-caret-square-o-left',
				413 => 'fa fa-dot-circle-o',
				414 => 'fa fa-wheelchair',
				415 => 'fa fa-vimeo-square',
				416 => 'fa fa-turkish-lira',
				417 => 'fa fa-try',
				418 => 'fa fa-plus-square-o',
				419 => 'fa fa-space-shuttle',
				420 => 'fa fa-slack',
				421 => 'fa fa-envelope-square',
				422 => 'fa fa-wordpress',
				423 => 'fa fa-openid',
				424 => 'fa fa-institution',
				425 => 'fa fa-bank',
				426 => 'fa fa-university',
				427 => 'fa fa-mortar-board',
				428 => 'fa fa-graduation-cap',
				429 => 'fa fa-yahoo',
				430 => 'fa fa-google',
				431 => 'fa fa-reddit',
				432 => 'fa fa-reddit-square',
				433 => 'fa fa-stumbleupon-circle',
				434 => 'fa fa-stumbleupon',
				435 => 'fa fa-delicious',
				436 => 'fa fa-digg',
				437 => 'fa fa-pied-piper-pp',
				438 => 'fa fa-pied-piper-alt',
				439 => 'fa fa-drupal',
				440 => 'fa fa-joomla',
				441 => 'fa fa-language',
				442 => 'fa fa-fax',
				443 => 'fa fa-building',
				444 => 'fa fa-child',
				445 => 'fa fa-paw',
				446 => 'fa fa-spoon',
				447 => 'fa fa-cube',
				448 => 'fa fa-cubes',
				449 => 'fa fa-behance',
				450 => 'fa fa-behance-square',
				451 => 'fa fa-steam',
				452 => 'fa fa-steam-square',
				453 => 'fa fa-recycle',
				454 => 'fa fa-automobile',
				455 => 'fa fa-car',
				456 => 'fa fa-cab',
				457 => 'fa fa-taxi',
				458 => 'fa fa-tree',
				459 => 'fa fa-spotify',
				460 => 'fa fa-deviantart',
				461 => 'fa fa-soundcloud',
				462 => 'fa fa-database',
				463 => 'fa fa-file-pdf-o',
				464 => 'fa fa-file-word-o',
				465 => 'fa fa-file-excel-o',
				466 => 'fa fa-file-powerpoint-o',
				467 => 'fa fa-file-photo-o',
				468 => 'fa fa-file-picture-o',
				469 => 'fa fa-file-image-o',
				470 => 'fa fa-file-zip-o',
				471 => 'fa fa-file-archive-o',
				472 => 'fa fa-file-sound-o',
				473 => 'fa fa-file-audio-o',
				474 => 'fa fa-file-movie-o',
				475 => 'fa fa-file-video-o',
				476 => 'fa fa-file-code-o',
				477 => 'fa fa-vine',
				478 => 'fa fa-codepen',
				479 => 'fa fa-jsfiddle',
				480 => 'fa fa-life-bouy',
				481 => 'fa fa-life-buoy',
				482 => 'fa fa-life-saver',
				483 => 'fa fa-support',
				484 => 'fa fa-life-ring',
				485 => 'fa fa-circle-o-notch',
				486 => 'fa fa-ra',
				487 => 'fa fa-resistance',
				488 => 'fa fa-rebel',
				489 => 'fa fa-ge',
				490 => 'fa fa-empire',
				491 => 'fa fa-git-square',
				492 => 'fa fa-git',
				493 => 'fa fa-y-combinator-square',
				494 => 'fa fa-yc-square',
				495 => 'fa fa-hacker-news',
				496 => 'fa fa-tencent-weibo',
				497 => 'fa fa-qq',
				498 => 'fa fa-wechat',
				499 => 'fa fa-weixin',
				500 => 'fa fa-send',
				501 => 'fa fa-paper-plane',
				502 => 'fa fa-send-o',
				503 => 'fa fa-paper-plane-o',
				504 => 'fa fa-history',
				505 => 'fa fa-circle-thin',
				506 => 'fa fa-header',
				507 => 'fa fa-paragraph',
				508 => 'fa fa-sliders',
				509 => 'fa fa-share-alt',
				510 => 'fa fa-share-alt-square',
				511 => 'fa fa-bomb',
				512 => 'fa fa-soccer-ball-o',
				513 => 'fa fa-futbol-o',
				514 => 'fa fa-tty',
				515 => 'fa fa-binoculars',
				516 => 'fa fa-plug',
				517 => 'fa fa-slideshare',
				518 => 'fa fa-twitch',
				519 => 'fa fa-yelp',
				520 => 'fa fa-newspaper-o',
				521 => 'fa fa-wifi',
				522 => 'fa fa-calculator',
				523 => 'fa fa-paypal',
				524 => 'fa fa-google-wallet',
				525 => 'fa fa-cc-visa',
				526 => 'fa fa-cc-mastercard',
				527 => 'fa fa-cc-discover',
				528 => 'fa fa-cc-amex',
				529 => 'fa fa-cc-paypal',
				530 => 'fa fa-cc-stripe',
				531 => 'fa fa-bell-slash',
				532 => 'fa fa-bell-slash-o',
				533 => 'fa fa-trash',
				534 => 'fa fa-copyright',
				535 => 'fa fa-at',
				536 => 'fa fa-eyedropper',
				537 => 'fa fa-paint-brush',
				538 => 'fa fa-birthday-cake',
				539 => 'fa fa-area-chart',
				540 => 'fa fa-pie-chart',
				541 => 'fa fa-line-chart',
				542 => 'fa fa-lastfm',
				543 => 'fa fa-lastfm-square',
				544 => 'fa fa-toggle-off',
				545 => 'fa fa-toggle-on',
				546 => 'fa fa-bicycle',
				547 => 'fa fa-bus',
				548 => 'fa fa-ioxhost',
				549 => 'fa fa-angellist',
				550 => 'fa fa-cc',
				551 => 'fa fa-shekel',
				552 => 'fa fa-sheqel',
				553 => 'fa fa-ils',
				554 => 'fa fa-meanpath',
				555 => 'fa fa-buysellads',
				556 => 'fa fa-connectdevelop',
				557 => 'fa fa-dashcube',
				558 => 'fa fa-forumbee',
				559 => 'fa fa-leanpub',
				560 => 'fa fa-sellsy',
				561 => 'fa fa-shirtsinbulk',
				562 => 'fa fa-simplybuilt',
				563 => 'fa fa-skyatlas',
				564 => 'fa fa-cart-plus',
				565 => 'fa fa-cart-arrow-down',
				566 => 'fa fa-diamond',
				567 => 'fa fa-ship',
				568 => 'fa fa-user-secret',
				569 => 'fa fa-motorcycle',
				570 => 'fa fa-street-view',
				571 => 'fa fa-heartbeat',
				572 => 'fa fa-venus',
				573 => 'fa fa-mars',
				574 => 'fa fa-mercury',
				575 => 'fa fa-intersex',
				576 => 'fa fa-transgender',
				577 => 'fa fa-transgender-alt',
				578 => 'fa fa-venus-double',
				579 => 'fa fa-mars-double',
				580 => 'fa fa-venus-mars',
				581 => 'fa fa-mars-stroke',
				582 => 'fa fa-mars-stroke-v',
				583 => 'fa fa-mars-stroke-h',
				584 => 'fa fa-neuter',
				585 => 'fa fa-genderless',
				586 => 'fa fa-facebook-official',
				587 => 'fa fa-pinterest-p',
				588 => 'fa fa-whatsapp',
				589 => 'fa fa-server',
				590 => 'fa fa-user-plus',
				591 => 'fa fa-user-times',
				592 => 'fa fa-hotel',
				593 => 'fa fa-bed',
				594 => 'fa fa-viacoin',
				595 => 'fa fa-train',
				596 => 'fa fa-subway',
				597 => 'fa fa-medium',
				598 => 'fa fa-yc',
				599 => 'fa fa-y-combinator',
				600 => 'fa fa-optin-monster',
				601 => 'fa fa-opencart',
				602 => 'fa fa-expeditedssl',
				603 => 'fa fa-battery-4',
				604 => 'fa fa-battery',
				605 => 'fa fa-battery-full',
				606 => 'fa fa-battery-3',
				607 => 'fa fa-battery-three-quarters',
				608 => 'fa fa-battery-2',
				609 => 'fa fa-battery-half',
				610 => 'fa fa-battery-1',
				611 => 'fa fa-battery-quarter',
				612 => 'fa fa-battery-0',
				613 => 'fa fa-battery-empty',
				614 => 'fa fa-mouse-pointer',
				615 => 'fa fa-i-cursor',
				616 => 'fa fa-object-group',
				617 => 'fa fa-object-ungroup',
				618 => 'fa fa-sticky-note',
				619 => 'fa fa-sticky-note-o',
				620 => 'fa fa-cc-jcb',
				621 => 'fa fa-cc-diners-club',
				622 => 'fa fa-clone',
				623 => 'fa fa-balance-scale',
				624 => 'fa fa-hourglass-o',
				625 => 'fa fa-hourglass-1',
				626 => 'fa fa-hourglass-start',
				627 => 'fa fa-hourglass-2',
				628 => 'fa fa-hourglass-half',
				629 => 'fa fa-hourglass-3',
				630 => 'fa fa-hourglass-end',
				631 => 'fa fa-hourglass',
				632 => 'fa fa-hand-grab-o',
				633 => 'fa fa-hand-rock-o',
				634 => 'fa fa-hand-stop-o',
				635 => 'fa fa-hand-paper-o',
				636 => 'fa fa-hand-scissors-o',
				637 => 'fa fa-hand-lizard-o',
				638 => 'fa fa-hand-spock-o',
				639 => 'fa fa-hand-pointer-o',
				640 => 'fa fa-hand-peace-o',
				641 => 'fa fa-trademark',
				642 => 'fa fa-registered',
				643 => 'fa fa-creative-commons',
				644 => 'fa fa-gg',
				645 => 'fa fa-gg-circle',
				646 => 'fa fa-tripadvisor',
				647 => 'fa fa-odnoklassniki',
				648 => 'fa fa-odnoklassniki-square',
				649 => 'fa fa-get-pocket',
				650 => 'fa fa-wikipedia-w',
				651 => 'fa fa-safari',
				652 => 'fa fa-chrome',
				653 => 'fa fa-firefox',
				654 => 'fa fa-opera',
				655 => 'fa fa-internet-explorer',
				656 => 'fa fa-tv',
				657 => 'fa fa-television',
				658 => 'fa fa-contao',
				659 => 'fa fa-500px',
				660 => 'fa fa-amazon',
				661 => 'fa fa-calendar-plus-o',
				662 => 'fa fa-calendar-minus-o',
				663 => 'fa fa-calendar-times-o',
				664 => 'fa fa-calendar-check-o',
				665 => 'fa fa-industry',
				666 => 'fa fa-map-pin',
				667 => 'fa fa-map-signs',
				668 => 'fa fa-map-o',
				669 => 'fa fa-map',
				670 => 'fa fa-commenting',
				671 => 'fa fa-commenting-o',
				672 => 'fa fa-houzz',
				673 => 'fa fa-vimeo',
				674 => 'fa fa-black-tie',
				675 => 'fa fa-fonticons',
				676 => 'fa fa-reddit-alien',
				677 => 'fa fa-edge',
				678 => 'fa fa-credit-card-alt',
				679 => 'fa fa-codiepie',
				680 => 'fa fa-modx',
				681 => 'fa fa-fort-awesome',
				682 => 'fa fa-usb',
				683 => 'fa fa-product-hunt',
				684 => 'fa fa-mixcloud',
				685 => 'fa fa-scribd',
				686 => 'fa fa-pause-circle',
				687 => 'fa fa-pause-circle-o',
				688 => 'fa fa-stop-circle',
				689 => 'fa fa-stop-circle-o',
				690 => 'fa fa-shopping-bag',
				691 => 'fa fa-shopping-basket',
				692 => 'fa fa-hashtag',
				693 => 'fa fa-bluetooth',
				694 => 'fa fa-bluetooth-b',
				695 => 'fa fa-percent',
				696 => 'fa fa-gitlab',
				697 => 'fa fa-wpbeginner',
				698 => 'fa fa-wpforms',
				699 => 'fa fa-envira',
				700 => 'fa fa-universal-access',
				701 => 'fa fa-wheelchair-alt',
				702 => 'fa fa-question-circle-o',
				703 => 'fa fa-blind',
				704 => 'fa fa-audio-description',
				705 => 'fa fa-volume-control-phone',
				706 => 'fa fa-braille',
				707 => 'fa fa-assistive-listening-systems',
				708 => 'fa fa-asl-interpreting',
				709 => 'fa fa-american-sign-language-interpreting',
				710 => 'fa fa-deafness',
				711 => 'fa fa-hard-of-hearing',
				712 => 'fa fa-deaf',
				713 => 'fa fa-glide',
				714 => 'fa fa-glide-g',
				715 => 'fa fa-signing',
				716 => 'fa fa-sign-language',
				717 => 'fa fa-low-vision',
				718 => 'fa fa-viadeo',
				719 => 'fa fa-viadeo-square',
				720 => 'fa fa-snapchat',
				721 => 'fa fa-snapchat-ghost',
				722 => 'fa fa-snapchat-square',
				723 => 'fa fa-pied-piper',
				724 => 'fa fa-first-order',
				725 => 'fa fa-yoast',
				726 => 'fa fa-themeisle',
				727 => 'fa fa-google-plus-circle',
				728 => 'fa fa-google-plus-official',
				729 => 'fa fa-fa',
				730 => 'fa fa-font-awesome',
				731 => 'fa fa-handshake-o',
				732 => 'fa fa-envelope-open',
				733 => 'fa fa-envelope-open-o',
				734 => 'fa fa-linode',
				735 => 'fa fa-address-book',
				736 => 'fa fa-address-book-o',
				737 => 'fa fa-vcard',
				738 => 'fa fa-address-card',
				739 => 'fa fa-vcard-o',
				740 => 'fa fa-address-card-o',
				741 => 'fa fa-user-circle',
				742 => 'fa fa-user-circle-o',
				743 => 'fa fa-user-o',
				744 => 'fa fa-id-badge',
				745 => 'fa fa-drivers-license',
				746 => 'fa fa-id-card',
				747 => 'fa fa-drivers-license-o',
				748 => 'fa fa-id-card-o',
				749 => 'fa fa-quora',
				750 => 'fa fa-free-code-camp',
				751 => 'fa fa-telegram',
				752 => 'fa fa-thermometer-4',
				753 => 'fa fa-thermometer',
				754 => 'fa fa-thermometer-full',
				755 => 'fa fa-thermometer-3',
				756 => 'fa fa-thermometer-three-quarters',
				757 => 'fa fa-thermometer-2',
				758 => 'fa fa-thermometer-half',
				759 => 'fa fa-thermometer-1',
				760 => 'fa fa-thermometer-quarter',
				761 => 'fa fa-thermometer-0',
				762 => 'fa fa-thermometer-empty',
				763 => 'fa fa-shower',
				764 => 'fa fa-bathtub',
				765 => 'fa fa-s15',
				766 => 'fa fa-bath',
				767 => 'fa fa-podcast',
				768 => 'fa fa-window-maximize',
				769 => 'fa fa-window-minimize',
				770 => 'fa fa-window-restore',
				771 => 'fa fa-times-rectangle',
				772 => 'fa fa-window-close',
				773 => 'fa fa-times-rectangle-o',
				774 => 'fa fa-window-close-o',
				775 => 'fa fa-bandcamp',
				776 => 'fa fa-grav',
				777 => 'fa fa-etsy',
				778 => 'fa fa-imdb',
				779 => 'fa fa-ravelry',
				780 => 'fa fa-eercast',
				781 => 'fa fa-microchip',
				782 => 'fa fa-snowflake-o',
				783 => 'fa fa-superpowers',
				784 => 'fa fa-wpexplorer',
				785 => 'fa fa-meetup',
			);

		return apply_filters('customify/customizer/font_icons/font_awesome_icons', $icons);
	}


	function get_font_awesome_icons6()
	{
		return
			array(
				0 => 'fa-solid fa-0',
				1 => 'fa-solid fa-1',
				2 => 'fa-solid fa-2',
				3 => 'fa-solid fa-3',
				4 => 'fa-solid fa-4',
				5 => 'fa-solid fa-5',
				6 => 'fa-solid fa-6',
				7 => 'fa-solid fa-7',
				8 => 'fa-solid fa-8',
				9 => 'fa-solid fa-9',
				10 => 'fa-brands fa-42-group',
				11 => 'fa-brands fa-500px',
				12 => 'fa-solid fa-a',
				13 => 'fa-brands fa-accessible-icon',
				14 => 'fa-brands fa-accusoft',
				15 => 'fa-solid fa-address-book',
				16 => 'fa-regular fa-address-book',
				17 => 'fa-solid fa-address-card',
				18 => 'fa-regular fa-address-card',
				19 => 'fa-brands fa-adn',
				20 => 'fa-brands fa-adversal',
				21 => 'fa-brands fa-affiliatetheme',
				22 => 'fa-brands fa-airbnb',
				23 => 'fa-brands fa-algolia',
				24 => 'fa-solid fa-align-center',
				25 => 'fa-solid fa-align-justify',
				26 => 'fa-solid fa-align-left',
				27 => 'fa-solid fa-align-right',
				28 => 'fa-brands fa-alipay',
				29 => 'fa-brands fa-amazon',
				30 => 'fa-brands fa-amazon-pay',
				31 => 'fa-brands fa-amilia',
				32 => 'fa-solid fa-anchor',
				33 => 'fa-solid fa-anchor-circle-check',
				34 => 'fa-solid fa-anchor-circle-exclamation',
				35 => 'fa-solid fa-anchor-circle-xmark',
				36 => 'fa-solid fa-anchor-lock',
				37 => 'fa-brands fa-android',
				38 => 'fa-brands fa-angellist',
				39 => 'fa-solid fa-angle-down',
				40 => 'fa-solid fa-angle-left',
				41 => 'fa-solid fa-angle-right',
				42 => 'fa-solid fa-angle-up',
				43 => 'fa-solid fa-angles-down',
				44 => 'fa-solid fa-angles-left',
				45 => 'fa-solid fa-angles-right',
				46 => 'fa-solid fa-angles-up',
				47 => 'fa-brands fa-angrycreative',
				48 => 'fa-brands fa-angular',
				49 => 'fa-solid fa-ankh',
				50 => 'fa-brands fa-app-store',
				51 => 'fa-brands fa-app-store-ios',
				52 => 'fa-brands fa-apper',
				53 => 'fa-brands fa-apple',
				54 => 'fa-brands fa-apple-pay',
				55 => 'fa-solid fa-apple-whole',
				56 => 'fa-solid fa-archway',
				57 => 'fa-solid fa-arrow-down',
				58 => 'fa-solid fa-arrow-down-1-9',
				59 => 'fa-solid fa-arrow-down-9-1',
				60 => 'fa-solid fa-arrow-down-a-z',
				61 => 'fa-solid fa-arrow-down-long',
				62 => 'fa-solid fa-arrow-down-short-wide',
				63 => 'fa-solid fa-arrow-down-up-across-line',
				64 => 'fa-solid fa-arrow-down-up-lock',
				65 => 'fa-solid fa-arrow-down-wide-short',
				66 => 'fa-solid fa-arrow-down-z-a',
				67 => 'fa-solid fa-arrow-left',
				68 => 'fa-solid fa-arrow-left-long',
				69 => 'fa-solid fa-arrow-pointer',
				70 => 'fa-solid fa-arrow-right',
				71 => 'fa-solid fa-arrow-right-arrow-left',
				72 => 'fa-solid fa-arrow-right-from-bracket',
				73 => 'fa-solid fa-arrow-right-long',
				74 => 'fa-solid fa-arrow-right-to-bracket',
				75 => 'fa-solid fa-arrow-right-to-city',
				76 => 'fa-solid fa-arrow-rotate-left',
				77 => 'fa-solid fa-arrow-rotate-right',
				78 => 'fa-solid fa-arrow-trend-down',
				79 => 'fa-solid fa-arrow-trend-up',
				80 => 'fa-solid fa-arrow-turn-down',
				81 => 'fa-solid fa-arrow-turn-up',
				82 => 'fa-solid fa-arrow-up',
				83 => 'fa-solid fa-arrow-up-1-9',
				84 => 'fa-solid fa-arrow-up-9-1',
				85 => 'fa-solid fa-arrow-up-a-z',
				86 => 'fa-solid fa-arrow-up-from-bracket',
				87 => 'fa-solid fa-arrow-up-from-ground-water',
				88 => 'fa-solid fa-arrow-up-from-water-pump',
				89 => 'fa-solid fa-arrow-up-long',
				90 => 'fa-solid fa-arrow-up-right-dots',
				91 => 'fa-solid fa-arrow-up-right-from-square',
				92 => 'fa-solid fa-arrow-up-short-wide',
				93 => 'fa-solid fa-arrow-up-wide-short',
				94 => 'fa-solid fa-arrow-up-z-a',
				95 => 'fa-solid fa-arrows-down-to-line',
				96 => 'fa-solid fa-arrows-down-to-people',
				97 => 'fa-solid fa-arrows-left-right',
				98 => 'fa-solid fa-arrows-left-right-to-line',
				99 => 'fa-solid fa-arrows-rotate',
				100 => 'fa-solid fa-arrows-spin',
				101 => 'fa-solid fa-arrows-split-up-and-left',
				102 => 'fa-solid fa-arrows-to-circle',
				103 => 'fa-solid fa-arrows-to-dot',
				104 => 'fa-solid fa-arrows-to-eye',
				105 => 'fa-solid fa-arrows-turn-right',
				106 => 'fa-solid fa-arrows-turn-to-dots',
				107 => 'fa-solid fa-arrows-up-down',
				108 => 'fa-solid fa-arrows-up-down-left-right',
				109 => 'fa-solid fa-arrows-up-to-line',
				110 => 'fa-brands fa-artstation',
				111 => 'fa-solid fa-asterisk',
				112 => 'fa-brands fa-asymmetrik',
				113 => 'fa-solid fa-at',
				114 => 'fa-brands fa-atlassian',
				115 => 'fa-solid fa-atom',
				116 => 'fa-brands fa-audible',
				117 => 'fa-solid fa-audio-description',
				118 => 'fa-solid fa-austral-sign',
				119 => 'fa-brands fa-autoprefixer',
				120 => 'fa-brands fa-avianex',
				121 => 'fa-brands fa-aviato',
				122 => 'fa-solid fa-award',
				123 => 'fa-brands fa-aws',
				124 => 'fa-solid fa-b',
				125 => 'fa-solid fa-baby',
				126 => 'fa-solid fa-baby-carriage',
				127 => 'fa-solid fa-backward',
				128 => 'fa-solid fa-backward-fast',
				129 => 'fa-solid fa-backward-step',
				130 => 'fa-solid fa-bacon',
				131 => 'fa-solid fa-bacteria',
				132 => 'fa-solid fa-bacterium',
				133 => 'fa-solid fa-bag-shopping',
				134 => 'fa-solid fa-bahai',
				135 => 'fa-solid fa-baht-sign',
				136 => 'fa-solid fa-ban',
				137 => 'fa-solid fa-ban-smoking',
				138 => 'fa-solid fa-bandage',
				139 => 'fa-brands fa-bandcamp',
				140 => 'fa-solid fa-barcode',
				141 => 'fa-solid fa-bars',
				142 => 'fa-solid fa-bars-progress',
				143 => 'fa-solid fa-bars-staggered',
				144 => 'fa-solid fa-baseball',
				145 => 'fa-solid fa-baseball-bat-ball',
				146 => 'fa-solid fa-basket-shopping',
				147 => 'fa-solid fa-basketball',
				148 => 'fa-solid fa-bath',
				149 => 'fa-solid fa-battery-empty',
				150 => 'fa-solid fa-battery-full',
				151 => 'fa-solid fa-battery-half',
				152 => 'fa-solid fa-battery-quarter',
				153 => 'fa-solid fa-battery-three-quarters',
				154 => 'fa-brands fa-battle-net',
				155 => 'fa-solid fa-bed',
				156 => 'fa-solid fa-bed-pulse',
				157 => 'fa-solid fa-beer-mug-empty',
				158 => 'fa-brands fa-behance',
				159 => 'fa-brands fa-behance-square',
				160 => 'fa-solid fa-bell',
				161 => 'fa-regular fa-bell',
				162 => 'fa-solid fa-bell-concierge',
				163 => 'fa-solid fa-bell-slash',
				164 => 'fa-regular fa-bell-slash',
				165 => 'fa-solid fa-bezier-curve',
				166 => 'fa-solid fa-bicycle',
				167 => 'fa-brands fa-bilibili',
				168 => 'fa-brands fa-bimobject',
				169 => 'fa-solid fa-binoculars',
				170 => 'fa-solid fa-biohazard',
				171 => 'fa-brands fa-bitbucket',
				172 => 'fa-brands fa-bitcoin',
				173 => 'fa-solid fa-bitcoin-sign',
				174 => 'fa-brands fa-bity',
				175 => 'fa-brands fa-black-tie',
				176 => 'fa-brands fa-blackberry',
				177 => 'fa-solid fa-blender',
				178 => 'fa-solid fa-blender-phone',
				179 => 'fa-solid fa-blog',
				180 => 'fa-brands fa-blogger',
				181 => 'fa-brands fa-blogger-b',
				182 => 'fa-brands fa-bluetooth',
				183 => 'fa-brands fa-bluetooth-b',
				184 => 'fa-solid fa-bold',
				185 => 'fa-solid fa-bolt',
				186 => 'fa-solid fa-bolt-lightning',
				187 => 'fa-solid fa-bomb',
				188 => 'fa-solid fa-bone',
				189 => 'fa-solid fa-bong',
				190 => 'fa-solid fa-book',
				191 => 'fa-solid fa-book-atlas',
				192 => 'fa-solid fa-book-bible',
				193 => 'fa-solid fa-book-bookmark',
				194 => 'fa-solid fa-book-journal-whills',
				195 => 'fa-solid fa-book-medical',
				196 => 'fa-solid fa-book-open',
				197 => 'fa-solid fa-book-open-reader',
				198 => 'fa-solid fa-book-quran',
				199 => 'fa-solid fa-book-skull',
				200 => 'fa-solid fa-bookmark',
				201 => 'fa-regular fa-bookmark',
				202 => 'fa-brands fa-bootstrap',
				203 => 'fa-solid fa-border-all',
				204 => 'fa-solid fa-border-none',
				205 => 'fa-solid fa-border-top-left',
				206 => 'fa-solid fa-bore-hole',
				207 => 'fa-brands fa-bots',
				208 => 'fa-solid fa-bottle-droplet',
				209 => 'fa-solid fa-bottle-water',
				210 => 'fa-solid fa-bowl-food',
				211 => 'fa-solid fa-bowl-rice',
				212 => 'fa-solid fa-bowling-ball',
				213 => 'fa-solid fa-box',
				214 => 'fa-solid fa-box-archive',
				215 => 'fa-solid fa-box-open',
				216 => 'fa-solid fa-box-tissue',
				217 => 'fa-solid fa-boxes-packing',
				218 => 'fa-solid fa-boxes-stacked',
				219 => 'fa-solid fa-braille',
				220 => 'fa-solid fa-brain',
				221 => 'fa-solid fa-brazilian-real-sign',
				222 => 'fa-solid fa-bread-slice',
				223 => 'fa-solid fa-bridge',
				224 => 'fa-solid fa-bridge-circle-check',
				225 => 'fa-solid fa-bridge-circle-exclamation',
				226 => 'fa-solid fa-bridge-circle-xmark',
				227 => 'fa-solid fa-bridge-lock',
				228 => 'fa-solid fa-bridge-water',
				229 => 'fa-solid fa-briefcase',
				230 => 'fa-solid fa-briefcase-medical',
				231 => 'fa-solid fa-broom',
				232 => 'fa-solid fa-broom-ball',
				233 => 'fa-solid fa-brush',
				234 => 'fa-brands fa-btc',
				235 => 'fa-solid fa-bucket',
				236 => 'fa-brands fa-buffer',
				237 => 'fa-solid fa-bug',
				238 => 'fa-solid fa-bug-slash',
				239 => 'fa-solid fa-bugs',
				240 => 'fa-solid fa-building',
				241 => 'fa-regular fa-building',
				242 => 'fa-solid fa-building-circle-arrow-right',
				243 => 'fa-solid fa-building-circle-check',
				244 => 'fa-solid fa-building-circle-exclamation',
				245 => 'fa-solid fa-building-circle-xmark',
				246 => 'fa-solid fa-building-columns',
				247 => 'fa-solid fa-building-flag',
				248 => 'fa-solid fa-building-lock',
				249 => 'fa-solid fa-building-ngo',
				250 => 'fa-solid fa-building-shield',
				251 => 'fa-solid fa-building-un',
				252 => 'fa-solid fa-building-user',
				253 => 'fa-solid fa-building-wheat',
				254 => 'fa-solid fa-bullhorn',
				255 => 'fa-solid fa-bullseye',
				256 => 'fa-solid fa-burger',
				257 => 'fa-brands fa-buromobelexperte',
				258 => 'fa-solid fa-burst',
				259 => 'fa-solid fa-bus',
				260 => 'fa-solid fa-bus-simple',
				261 => 'fa-solid fa-business-time',
				262 => 'fa-brands fa-buy-n-large',
				263 => 'fa-brands fa-buysellads',
				264 => 'fa-solid fa-c',
				265 => 'fa-solid fa-cake-candles',
				266 => 'fa-solid fa-calculator',
				267 => 'fa-solid fa-calendar',
				268 => 'fa-regular fa-calendar',
				269 => 'fa-solid fa-calendar-check',
				270 => 'fa-regular fa-calendar-check',
				271 => 'fa-solid fa-calendar-day',
				272 => 'fa-solid fa-calendar-days',
				273 => 'fa-regular fa-calendar-days',
				274 => 'fa-solid fa-calendar-minus',
				275 => 'fa-regular fa-calendar-minus',
				276 => 'fa-solid fa-calendar-plus',
				277 => 'fa-regular fa-calendar-plus',
				278 => 'fa-solid fa-calendar-week',
				279 => 'fa-solid fa-calendar-xmark',
				280 => 'fa-regular fa-calendar-xmark',
				281 => 'fa-solid fa-camera',
				282 => 'fa-solid fa-camera-retro',
				283 => 'fa-solid fa-camera-rotate',
				284 => 'fa-solid fa-campground',
				285 => 'fa-brands fa-canadian-maple-leaf',
				286 => 'fa-solid fa-candy-cane',
				287 => 'fa-solid fa-cannabis',
				288 => 'fa-solid fa-capsules',
				289 => 'fa-solid fa-car',
				290 => 'fa-solid fa-car-battery',
				291 => 'fa-solid fa-car-burst',
				292 => 'fa-solid fa-car-on',
				293 => 'fa-solid fa-car-rear',
				294 => 'fa-solid fa-car-side',
				295 => 'fa-solid fa-car-tunnel',
				296 => 'fa-solid fa-caravan',
				297 => 'fa-solid fa-caret-down',
				298 => 'fa-solid fa-caret-left',
				299 => 'fa-solid fa-caret-right',
				300 => 'fa-solid fa-caret-up',
				301 => 'fa-solid fa-carrot',
				302 => 'fa-solid fa-cart-arrow-down',
				303 => 'fa-solid fa-cart-flatbed',
				304 => 'fa-solid fa-cart-flatbed-suitcase',
				305 => 'fa-solid fa-cart-plus',
				306 => 'fa-solid fa-cart-shopping',
				307 => 'fa-solid fa-cash-register',
				308 => 'fa-solid fa-cat',
				309 => 'fa-brands fa-cc-amazon-pay',
				310 => 'fa-brands fa-cc-amex',
				311 => 'fa-brands fa-cc-apple-pay',
				312 => 'fa-brands fa-cc-diners-club',
				313 => 'fa-brands fa-cc-discover',
				314 => 'fa-brands fa-cc-jcb',
				315 => 'fa-brands fa-cc-mastercard',
				316 => 'fa-brands fa-cc-paypal',
				317 => 'fa-brands fa-cc-stripe',
				318 => 'fa-brands fa-cc-visa',
				319 => 'fa-solid fa-cedi-sign',
				320 => 'fa-solid fa-cent-sign',
				321 => 'fa-brands fa-centercode',
				322 => 'fa-brands fa-centos',
				323 => 'fa-solid fa-certificate',
				324 => 'fa-solid fa-chair',
				325 => 'fa-solid fa-chalkboard',
				326 => 'fa-solid fa-chalkboard-user',
				327 => 'fa-solid fa-champagne-glasses',
				328 => 'fa-solid fa-charging-station',
				329 => 'fa-solid fa-chart-area',
				330 => 'fa-solid fa-chart-bar',
				331 => 'fa-regular fa-chart-bar',
				332 => 'fa-solid fa-chart-column',
				333 => 'fa-solid fa-chart-gantt',
				334 => 'fa-solid fa-chart-line',
				335 => 'fa-solid fa-chart-pie',
				336 => 'fa-solid fa-chart-simple',
				337 => 'fa-solid fa-check',
				338 => 'fa-solid fa-check-double',
				339 => 'fa-solid fa-check-to-slot',
				340 => 'fa-solid fa-cheese',
				341 => 'fa-solid fa-chess',
				342 => 'fa-solid fa-chess-bishop',
				343 => 'fa-regular fa-chess-bishop',
				344 => 'fa-solid fa-chess-board',
				345 => 'fa-solid fa-chess-king',
				346 => 'fa-regular fa-chess-king',
				347 => 'fa-solid fa-chess-knight',
				348 => 'fa-regular fa-chess-knight',
				349 => 'fa-solid fa-chess-pawn',
				350 => 'fa-regular fa-chess-pawn',
				351 => 'fa-solid fa-chess-queen',
				352 => 'fa-regular fa-chess-queen',
				353 => 'fa-solid fa-chess-rook',
				354 => 'fa-regular fa-chess-rook',
				355 => 'fa-solid fa-chevron-down',
				356 => 'fa-solid fa-chevron-left',
				357 => 'fa-solid fa-chevron-right',
				358 => 'fa-solid fa-chevron-up',
				359 => 'fa-solid fa-child',
				360 => 'fa-solid fa-child-dress',
				361 => 'fa-solid fa-child-reaching',
				362 => 'fa-solid fa-child-rifle',
				363 => 'fa-solid fa-children',
				364 => 'fa-brands fa-chrome',
				365 => 'fa-brands fa-chromecast',
				366 => 'fa-solid fa-church',
				367 => 'fa-solid fa-circle',
				368 => 'fa-regular fa-circle',
				369 => 'fa-solid fa-circle-arrow-down',
				370 => 'fa-solid fa-circle-arrow-left',
				371 => 'fa-solid fa-circle-arrow-right',
				372 => 'fa-solid fa-circle-arrow-up',
				373 => 'fa-solid fa-circle-check',
				374 => 'fa-regular fa-circle-check',
				375 => 'fa-solid fa-circle-chevron-down',
				376 => 'fa-solid fa-circle-chevron-left',
				377 => 'fa-solid fa-circle-chevron-right',
				378 => 'fa-solid fa-circle-chevron-up',
				379 => 'fa-solid fa-circle-dollar-to-slot',
				380 => 'fa-solid fa-circle-dot',
				381 => 'fa-regular fa-circle-dot',
				382 => 'fa-solid fa-circle-down',
				383 => 'fa-regular fa-circle-down',
				384 => 'fa-solid fa-circle-exclamation',
				385 => 'fa-solid fa-circle-h',
				386 => 'fa-solid fa-circle-half-stroke',
				387 => 'fa-solid fa-circle-info',
				388 => 'fa-solid fa-circle-left',
				389 => 'fa-regular fa-circle-left',
				390 => 'fa-solid fa-circle-minus',
				391 => 'fa-solid fa-circle-nodes',
				392 => 'fa-solid fa-circle-notch',
				393 => 'fa-solid fa-circle-pause',
				394 => 'fa-regular fa-circle-pause',
				395 => 'fa-solid fa-circle-play',
				396 => 'fa-regular fa-circle-play',
				397 => 'fa-solid fa-circle-plus',
				398 => 'fa-solid fa-circle-question',
				399 => 'fa-regular fa-circle-question',
				400 => 'fa-solid fa-circle-radiation',
				401 => 'fa-solid fa-circle-right',
				402 => 'fa-regular fa-circle-right',
				403 => 'fa-solid fa-circle-stop',
				404 => 'fa-regular fa-circle-stop',
				405 => 'fa-solid fa-circle-up',
				406 => 'fa-regular fa-circle-up',
				407 => 'fa-solid fa-circle-user',
				408 => 'fa-regular fa-circle-user',
				409 => 'fa-solid fa-circle-xmark',
				410 => 'fa-regular fa-circle-xmark',
				411 => 'fa-solid fa-city',
				412 => 'fa-solid fa-clapperboard',
				413 => 'fa-solid fa-clipboard',
				414 => 'fa-regular fa-clipboard',
				415 => 'fa-solid fa-clipboard-check',
				416 => 'fa-solid fa-clipboard-list',
				417 => 'fa-solid fa-clipboard-question',
				418 => 'fa-solid fa-clipboard-user',
				419 => 'fa-solid fa-clock',
				420 => 'fa-regular fa-clock',
				421 => 'fa-solid fa-clock-rotate-left',
				422 => 'fa-solid fa-clone',
				423 => 'fa-regular fa-clone',
				424 => 'fa-solid fa-closed-captioning',
				425 => 'fa-regular fa-closed-captioning',
				426 => 'fa-solid fa-cloud',
				427 => 'fa-solid fa-cloud-arrow-down',
				428 => 'fa-solid fa-cloud-arrow-up',
				429 => 'fa-solid fa-cloud-bolt',
				430 => 'fa-solid fa-cloud-meatball',
				431 => 'fa-solid fa-cloud-moon',
				432 => 'fa-solid fa-cloud-moon-rain',
				433 => 'fa-solid fa-cloud-rain',
				434 => 'fa-solid fa-cloud-showers-heavy',
				435 => 'fa-solid fa-cloud-showers-water',
				436 => 'fa-solid fa-cloud-sun',
				437 => 'fa-solid fa-cloud-sun-rain',
				438 => 'fa-brands fa-cloudflare',
				439 => 'fa-brands fa-cloudscale',
				440 => 'fa-brands fa-cloudsmith',
				441 => 'fa-brands fa-cloudversify',
				442 => 'fa-solid fa-clover',
				443 => 'fa-brands fa-cmplid',
				444 => 'fa-solid fa-code',
				445 => 'fa-solid fa-code-branch',
				446 => 'fa-solid fa-code-commit',
				447 => 'fa-solid fa-code-compare',
				448 => 'fa-solid fa-code-fork',
				449 => 'fa-solid fa-code-merge',
				450 => 'fa-solid fa-code-pull-request',
				451 => 'fa-brands fa-codepen',
				452 => 'fa-brands fa-codiepie',
				453 => 'fa-solid fa-coins',
				454 => 'fa-solid fa-colon-sign',
				455 => 'fa-solid fa-comment',
				456 => 'fa-regular fa-comment',
				457 => 'fa-solid fa-comment-dollar',
				458 => 'fa-solid fa-comment-dots',
				459 => 'fa-regular fa-comment-dots',
				460 => 'fa-solid fa-comment-medical',
				461 => 'fa-solid fa-comment-slash',
				462 => 'fa-solid fa-comment-sms',
				463 => 'fa-solid fa-comments',
				464 => 'fa-regular fa-comments',
				465 => 'fa-solid fa-comments-dollar',
				466 => 'fa-solid fa-compact-disc',
				467 => 'fa-solid fa-compass',
				468 => 'fa-regular fa-compass',
				469 => 'fa-solid fa-compass-drafting',
				470 => 'fa-solid fa-compress',
				471 => 'fa-solid fa-computer',
				472 => 'fa-solid fa-computer-mouse',
				473 => 'fa-brands fa-confluence',
				474 => 'fa-brands fa-connectdevelop',
				475 => 'fa-brands fa-contao',
				476 => 'fa-solid fa-cookie',
				477 => 'fa-solid fa-cookie-bite',
				478 => 'fa-solid fa-copy',
				479 => 'fa-regular fa-copy',
				480 => 'fa-solid fa-copyright',
				481 => 'fa-regular fa-copyright',
				482 => 'fa-brands fa-cotton-bureau',
				483 => 'fa-solid fa-couch',
				484 => 'fa-solid fa-cow',
				485 => 'fa-brands fa-cpanel',
				486 => 'fa-brands fa-creative-commons',
				487 => 'fa-brands fa-creative-commons-by',
				488 => 'fa-brands fa-creative-commons-nc',
				489 => 'fa-brands fa-creative-commons-nc-eu',
				490 => 'fa-brands fa-creative-commons-nc-jp',
				491 => 'fa-brands fa-creative-commons-nd',
				492 => 'fa-brands fa-creative-commons-pd',
				493 => 'fa-brands fa-creative-commons-pd-alt',
				494 => 'fa-brands fa-creative-commons-remix',
				495 => 'fa-brands fa-creative-commons-sa',
				496 => 'fa-brands fa-creative-commons-sampling',
				497 => 'fa-brands fa-creative-commons-sampling-plus',
				498 => 'fa-brands fa-creative-commons-share',
				499 => 'fa-brands fa-creative-commons-zero',
				500 => 'fa-solid fa-credit-card',
				501 => 'fa-regular fa-credit-card',
				502 => 'fa-brands fa-critical-role',
				503 => 'fa-solid fa-crop',
				504 => 'fa-solid fa-crop-simple',
				505 => 'fa-solid fa-cross',
				506 => 'fa-solid fa-crosshairs',
				507 => 'fa-solid fa-crow',
				508 => 'fa-solid fa-crown',
				509 => 'fa-solid fa-crutch',
				510 => 'fa-solid fa-cruzeiro-sign',
				511 => 'fa-brands fa-css3',
				512 => 'fa-brands fa-css3-alt',
				513 => 'fa-solid fa-cube',
				514 => 'fa-solid fa-cubes',
				515 => 'fa-solid fa-cubes-stacked',
				516 => 'fa-brands fa-cuttlefish',
				517 => 'fa-solid fa-d',
				518 => 'fa-brands fa-d-and-d',
				519 => 'fa-brands fa-d-and-d-beyond',
				520 => 'fa-brands fa-dailymotion',
				521 => 'fa-brands fa-dashcube',
				522 => 'fa-solid fa-database',
				523 => 'fa-brands fa-deezer',
				524 => 'fa-solid fa-delete-left',
				525 => 'fa-brands fa-delicious',
				526 => 'fa-solid fa-democrat',
				527 => 'fa-brands fa-deploydog',
				528 => 'fa-brands fa-deskpro',
				529 => 'fa-solid fa-desktop',
				530 => 'fa-brands fa-dev',
				531 => 'fa-brands fa-deviantart',
				532 => 'fa-solid fa-dharmachakra',
				533 => 'fa-brands fa-dhl',
				534 => 'fa-solid fa-diagram-next',
				535 => 'fa-solid fa-diagram-predecessor',
				536 => 'fa-solid fa-diagram-project',
				537 => 'fa-solid fa-diagram-successor',
				538 => 'fa-solid fa-diamond',
				539 => 'fa-solid fa-diamond-turn-right',
				540 => 'fa-brands fa-diaspora',
				541 => 'fa-solid fa-dice',
				542 => 'fa-solid fa-dice-d20',
				543 => 'fa-solid fa-dice-d6',
				544 => 'fa-solid fa-dice-five',
				545 => 'fa-solid fa-dice-four',
				546 => 'fa-solid fa-dice-one',
				547 => 'fa-solid fa-dice-six',
				548 => 'fa-solid fa-dice-three',
				549 => 'fa-solid fa-dice-two',
				550 => 'fa-brands fa-digg',
				551 => 'fa-brands fa-digital-ocean',
				552 => 'fa-brands fa-discord',
				553 => 'fa-brands fa-discourse',
				554 => 'fa-solid fa-disease',
				555 => 'fa-solid fa-display',
				556 => 'fa-solid fa-divide',
				557 => 'fa-solid fa-dna',
				558 => 'fa-brands fa-dochub',
				559 => 'fa-brands fa-docker',
				560 => 'fa-solid fa-dog',
				561 => 'fa-solid fa-dollar-sign',
				562 => 'fa-solid fa-dolly',
				563 => 'fa-solid fa-dong-sign',
				564 => 'fa-solid fa-door-closed',
				565 => 'fa-solid fa-door-open',
				566 => 'fa-solid fa-dove',
				567 => 'fa-solid fa-down-left-and-up-right-to-center',
				568 => 'fa-solid fa-down-long',
				569 => 'fa-solid fa-download',
				570 => 'fa-brands fa-draft2digital',
				571 => 'fa-solid fa-dragon',
				572 => 'fa-solid fa-draw-polygon',
				573 => 'fa-brands fa-dribbble',
				574 => 'fa-brands fa-dribbble-square',
				575 => 'fa-brands fa-dropbox',
				576 => 'fa-solid fa-droplet',
				577 => 'fa-solid fa-droplet-slash',
				578 => 'fa-solid fa-drum',
				579 => 'fa-solid fa-drum-steelpan',
				580 => 'fa-solid fa-drumstick-bite',
				581 => 'fa-brands fa-drupal',
				582 => 'fa-solid fa-dumbbell',
				583 => 'fa-solid fa-dumpster',
				584 => 'fa-solid fa-dumpster-fire',
				585 => 'fa-solid fa-dungeon',
				586 => 'fa-brands fa-dyalog',
				587 => 'fa-solid fa-e',
				588 => 'fa-solid fa-ear-deaf',
				589 => 'fa-solid fa-ear-listen',
				590 => 'fa-brands fa-earlybirds',
				591 => 'fa-solid fa-earth-africa',
				592 => 'fa-solid fa-earth-americas',
				593 => 'fa-solid fa-earth-asia',
				594 => 'fa-solid fa-earth-europe',
				595 => 'fa-solid fa-earth-oceania',
				596 => 'fa-brands fa-ebay',
				597 => 'fa-brands fa-edge',
				598 => 'fa-brands fa-edge-legacy',
				599 => 'fa-solid fa-egg',
				600 => 'fa-solid fa-eject',
				601 => 'fa-brands fa-elementor',
				602 => 'fa-solid fa-elevator',
				603 => 'fa-solid fa-ellipsis',
				604 => 'fa-solid fa-ellipsis-vertical',
				605 => 'fa-brands fa-ello',
				606 => 'fa-brands fa-ember',
				607 => 'fa-brands fa-empire',
				608 => 'fa-solid fa-envelope',
				609 => 'fa-regular fa-envelope',
				610 => 'fa-solid fa-envelope-circle-check',
				611 => 'fa-solid fa-envelope-open',
				612 => 'fa-regular fa-envelope-open',
				613 => 'fa-solid fa-envelope-open-text',
				614 => 'fa-solid fa-envelopes-bulk',
				615 => 'fa-brands fa-envira',
				616 => 'fa-solid fa-equals',
				617 => 'fa-solid fa-eraser',
				618 => 'fa-brands fa-erlang',
				619 => 'fa-brands fa-ethereum',
				620 => 'fa-solid fa-ethernet',
				621 => 'fa-brands fa-etsy',
				622 => 'fa-solid fa-euro-sign',
				623 => 'fa-brands fa-evernote',
				624 => 'fa-solid fa-exclamation',
				625 => 'fa-solid fa-expand',
				626 => 'fa-brands fa-expeditedssl',
				627 => 'fa-solid fa-explosion',
				628 => 'fa-solid fa-eye',
				629 => 'fa-regular fa-eye',
				630 => 'fa-solid fa-eye-dropper',
				631 => 'fa-solid fa-eye-low-vision',
				632 => 'fa-solid fa-eye-slash',
				633 => 'fa-regular fa-eye-slash',
				634 => 'fa-solid fa-f',
				635 => 'fa-solid fa-face-angry',
				636 => 'fa-regular fa-face-angry',
				637 => 'fa-solid fa-face-dizzy',
				638 => 'fa-regular fa-face-dizzy',
				639 => 'fa-solid fa-face-flushed',
				640 => 'fa-regular fa-face-flushed',
				641 => 'fa-solid fa-face-frown',
				642 => 'fa-regular fa-face-frown',
				643 => 'fa-solid fa-face-frown-open',
				644 => 'fa-regular fa-face-frown-open',
				645 => 'fa-solid fa-face-grimace',
				646 => 'fa-regular fa-face-grimace',
				647 => 'fa-solid fa-face-grin',
				648 => 'fa-regular fa-face-grin',
				649 => 'fa-solid fa-face-grin-beam',
				650 => 'fa-regular fa-face-grin-beam',
				651 => 'fa-solid fa-face-grin-beam-sweat',
				652 => 'fa-regular fa-face-grin-beam-sweat',
				653 => 'fa-solid fa-face-grin-hearts',
				654 => 'fa-regular fa-face-grin-hearts',
				655 => 'fa-solid fa-face-grin-squint',
				656 => 'fa-regular fa-face-grin-squint',
				657 => 'fa-solid fa-face-grin-squint-tears',
				658 => 'fa-regular fa-face-grin-squint-tears',
				659 => 'fa-solid fa-face-grin-stars',
				660 => 'fa-regular fa-face-grin-stars',
				661 => 'fa-solid fa-face-grin-tears',
				662 => 'fa-regular fa-face-grin-tears',
				663 => 'fa-solid fa-face-grin-tongue',
				664 => 'fa-regular fa-face-grin-tongue',
				665 => 'fa-solid fa-face-grin-tongue-squint',
				666 => 'fa-regular fa-face-grin-tongue-squint',
				667 => 'fa-solid fa-face-grin-tongue-wink',
				668 => 'fa-regular fa-face-grin-tongue-wink',
				669 => 'fa-solid fa-face-grin-wide',
				670 => 'fa-regular fa-face-grin-wide',
				671 => 'fa-solid fa-face-grin-wink',
				672 => 'fa-regular fa-face-grin-wink',
				673 => 'fa-solid fa-face-kiss',
				674 => 'fa-regular fa-face-kiss',
				675 => 'fa-solid fa-face-kiss-beam',
				676 => 'fa-regular fa-face-kiss-beam',
				677 => 'fa-solid fa-face-kiss-wink-heart',
				678 => 'fa-regular fa-face-kiss-wink-heart',
				679 => 'fa-solid fa-face-laugh',
				680 => 'fa-regular fa-face-laugh',
				681 => 'fa-solid fa-face-laugh-beam',
				682 => 'fa-regular fa-face-laugh-beam',
				683 => 'fa-solid fa-face-laugh-squint',
				684 => 'fa-regular fa-face-laugh-squint',
				685 => 'fa-solid fa-face-laugh-wink',
				686 => 'fa-regular fa-face-laugh-wink',
				687 => 'fa-solid fa-face-meh',
				688 => 'fa-regular fa-face-meh',
				689 => 'fa-solid fa-face-meh-blank',
				690 => 'fa-regular fa-face-meh-blank',
				691 => 'fa-solid fa-face-rolling-eyes',
				692 => 'fa-regular fa-face-rolling-eyes',
				693 => 'fa-solid fa-face-sad-cry',
				694 => 'fa-regular fa-face-sad-cry',
				695 => 'fa-solid fa-face-sad-tear',
				696 => 'fa-regular fa-face-sad-tear',
				697 => 'fa-solid fa-face-smile',
				698 => 'fa-regular fa-face-smile',
				699 => 'fa-solid fa-face-smile-beam',
				700 => 'fa-regular fa-face-smile-beam',
				701 => 'fa-solid fa-face-smile-wink',
				702 => 'fa-regular fa-face-smile-wink',
				703 => 'fa-solid fa-face-surprise',
				704 => 'fa-regular fa-face-surprise',
				705 => 'fa-solid fa-face-tired',
				706 => 'fa-regular fa-face-tired',
				707 => 'fa-brands fa-facebook',
				708 => 'fa-brands fa-facebook-f',
				709 => 'fa-brands fa-facebook-messenger',
				710 => 'fa-brands fa-facebook-square',
				711 => 'fa-solid fa-fan',
				712 => 'fa-brands fa-fantasy-flight-games',
				713 => 'fa-solid fa-faucet',
				714 => 'fa-solid fa-faucet-drip',
				715 => 'fa-solid fa-fax',
				716 => 'fa-solid fa-feather',
				717 => 'fa-solid fa-feather-pointed',
				718 => 'fa-brands fa-fedex',
				719 => 'fa-brands fa-fedora',
				720 => 'fa-solid fa-ferry',
				721 => 'fa-brands fa-figma',
				722 => 'fa-solid fa-file',
				723 => 'fa-regular fa-file',
				724 => 'fa-solid fa-file-arrow-down',
				725 => 'fa-solid fa-file-arrow-up',
				726 => 'fa-solid fa-file-audio',
				727 => 'fa-regular fa-file-audio',
				728 => 'fa-solid fa-file-circle-check',
				729 => 'fa-solid fa-file-circle-exclamation',
				730 => 'fa-solid fa-file-circle-minus',
				731 => 'fa-solid fa-file-circle-plus',
				732 => 'fa-solid fa-file-circle-question',
				733 => 'fa-solid fa-file-circle-xmark',
				734 => 'fa-solid fa-file-code',
				735 => 'fa-regular fa-file-code',
				736 => 'fa-solid fa-file-contract',
				737 => 'fa-solid fa-file-csv',
				738 => 'fa-solid fa-file-excel',
				739 => 'fa-regular fa-file-excel',
				740 => 'fa-solid fa-file-export',
				741 => 'fa-solid fa-file-image',
				742 => 'fa-regular fa-file-image',
				743 => 'fa-solid fa-file-import',
				744 => 'fa-solid fa-file-invoice',
				745 => 'fa-solid fa-file-invoice-dollar',
				746 => 'fa-solid fa-file-lines',
				747 => 'fa-regular fa-file-lines',
				748 => 'fa-solid fa-file-medical',
				749 => 'fa-solid fa-file-pdf',
				750 => 'fa-regular fa-file-pdf',
				751 => 'fa-solid fa-file-pen',
				752 => 'fa-solid fa-file-powerpoint',
				753 => 'fa-regular fa-file-powerpoint',
				754 => 'fa-solid fa-file-prescription',
				755 => 'fa-solid fa-file-shield',
				756 => 'fa-solid fa-file-signature',
				757 => 'fa-solid fa-file-video',
				758 => 'fa-regular fa-file-video',
				759 => 'fa-solid fa-file-waveform',
				760 => 'fa-solid fa-file-word',
				761 => 'fa-regular fa-file-word',
				762 => 'fa-solid fa-file-zipper',
				763 => 'fa-regular fa-file-zipper',
				764 => 'fa-solid fa-fill',
				765 => 'fa-solid fa-fill-drip',
				766 => 'fa-solid fa-film',
				767 => 'fa-solid fa-filter',
				768 => 'fa-solid fa-filter-circle-dollar',
				769 => 'fa-solid fa-filter-circle-xmark',
				770 => 'fa-solid fa-fingerprint',
				771 => 'fa-solid fa-fire',
				772 => 'fa-solid fa-fire-burner',
				773 => 'fa-solid fa-fire-extinguisher',
				774 => 'fa-solid fa-fire-flame-curved',
				775 => 'fa-solid fa-fire-flame-simple',
				776 => 'fa-brands fa-firefox',
				777 => 'fa-brands fa-firefox-browser',
				778 => 'fa-brands fa-first-order',
				779 => 'fa-brands fa-first-order-alt',
				780 => 'fa-brands fa-firstdraft',
				781 => 'fa-solid fa-fish',
				782 => 'fa-solid fa-fish-fins',
				783 => 'fa-solid fa-flag',
				784 => 'fa-regular fa-flag',
				785 => 'fa-solid fa-flag-checkered',
				786 => 'fa-solid fa-flag-usa',
				787 => 'fa-solid fa-flask',
				788 => 'fa-solid fa-flask-vial',
				789 => 'fa-brands fa-flickr',
				790 => 'fa-brands fa-flipboard',
				791 => 'fa-solid fa-floppy-disk',
				792 => 'fa-regular fa-floppy-disk',
				793 => 'fa-solid fa-florin-sign',
				794 => 'fa-brands fa-fly',
				795 => 'fa-solid fa-folder',
				796 => 'fa-regular fa-folder',
				797 => 'fa-solid fa-folder-closed',
				798 => 'fa-regular fa-folder-closed',
				799 => 'fa-solid fa-folder-minus',
				800 => 'fa-solid fa-folder-open',
				801 => 'fa-regular fa-folder-open',
				802 => 'fa-solid fa-folder-plus',
				803 => 'fa-solid fa-folder-tree',
				804 => 'fa-solid fa-font',
				805 => 'fa-solid fa-font-awesome',
				806 => 'fa-regular fa-font-awesome',
				807 => 'fa-brands fa-font-awesome',
				808 => 'fa-brands fa-fonticons',
				809 => 'fa-brands fa-fonticons-fi',
				810 => 'fa-solid fa-football',
				811 => 'fa-brands fa-fort-awesome',
				812 => 'fa-brands fa-fort-awesome-alt',
				813 => 'fa-brands fa-forumbee',
				814 => 'fa-solid fa-forward',
				815 => 'fa-solid fa-forward-fast',
				816 => 'fa-solid fa-forward-step',
				817 => 'fa-brands fa-foursquare',
				818 => 'fa-solid fa-franc-sign',
				819 => 'fa-brands fa-free-code-camp',
				820 => 'fa-brands fa-freebsd',
				821 => 'fa-solid fa-frog',
				822 => 'fa-brands fa-fulcrum',
				823 => 'fa-solid fa-futbol',
				824 => 'fa-regular fa-futbol',
				825 => 'fa-solid fa-g',
				826 => 'fa-brands fa-galactic-republic',
				827 => 'fa-brands fa-galactic-senate',
				828 => 'fa-solid fa-gamepad',
				829 => 'fa-solid fa-gas-pump',
				830 => 'fa-solid fa-gauge',
				831 => 'fa-solid fa-gauge-high',
				832 => 'fa-solid fa-gauge-simple',
				833 => 'fa-solid fa-gauge-simple-high',
				834 => 'fa-solid fa-gavel',
				835 => 'fa-solid fa-gear',
				836 => 'fa-solid fa-gears',
				837 => 'fa-solid fa-gem',
				838 => 'fa-regular fa-gem',
				839 => 'fa-solid fa-genderless',
				840 => 'fa-brands fa-get-pocket',
				841 => 'fa-brands fa-gg',
				842 => 'fa-brands fa-gg-circle',
				843 => 'fa-solid fa-ghost',
				844 => 'fa-solid fa-gift',
				845 => 'fa-solid fa-gifts',
				846 => 'fa-brands fa-git',
				847 => 'fa-brands fa-git-alt',
				848 => 'fa-brands fa-git-square',
				849 => 'fa-brands fa-github',
				850 => 'fa-brands fa-github-alt',
				851 => 'fa-brands fa-github-square',
				852 => 'fa-brands fa-gitkraken',
				853 => 'fa-brands fa-gitlab',
				854 => 'fa-brands fa-gitter',
				855 => 'fa-solid fa-glass-water',
				856 => 'fa-solid fa-glass-water-droplet',
				857 => 'fa-solid fa-glasses',
				858 => 'fa-brands fa-glide',
				859 => 'fa-brands fa-glide-g',
				860 => 'fa-solid fa-globe',
				861 => 'fa-brands fa-gofore',
				862 => 'fa-brands fa-golang',
				863 => 'fa-solid fa-golf-ball-tee',
				864 => 'fa-brands fa-goodreads',
				865 => 'fa-brands fa-goodreads-g',
				866 => 'fa-brands fa-google',
				867 => 'fa-brands fa-google-drive',
				868 => 'fa-brands fa-google-pay',
				869 => 'fa-brands fa-google-play',
				870 => 'fa-brands fa-google-plus',
				871 => 'fa-brands fa-google-plus-g',
				872 => 'fa-brands fa-google-plus-square',
				873 => 'fa-brands fa-google-wallet',
				874 => 'fa-solid fa-gopuram',
				875 => 'fa-solid fa-graduation-cap',
				876 => 'fa-brands fa-gratipay',
				877 => 'fa-brands fa-grav',
				878 => 'fa-solid fa-greater-than',
				879 => 'fa-solid fa-greater-than-equal',
				880 => 'fa-solid fa-grip',
				881 => 'fa-solid fa-grip-lines',
				882 => 'fa-solid fa-grip-lines-vertical',
				883 => 'fa-solid fa-grip-vertical',
				884 => 'fa-brands fa-gripfire',
				885 => 'fa-solid fa-group-arrows-rotate',
				886 => 'fa-brands fa-grunt',
				887 => 'fa-solid fa-guarani-sign',
				888 => 'fa-brands fa-guilded',
				889 => 'fa-solid fa-guitar',
				890 => 'fa-brands fa-gulp',
				891 => 'fa-solid fa-gun',
				892 => 'fa-solid fa-h',
				893 => 'fa-brands fa-hacker-news',
				894 => 'fa-brands fa-hacker-news-square',
				895 => 'fa-brands fa-hackerrank',
				896 => 'fa-solid fa-hammer',
				897 => 'fa-solid fa-hamsa',
				898 => 'fa-solid fa-hand',
				899 => 'fa-regular fa-hand',
				900 => 'fa-solid fa-hand-back-fist',
				901 => 'fa-regular fa-hand-back-fist',
				902 => 'fa-solid fa-hand-dots',
				903 => 'fa-solid fa-hand-fist',
				904 => 'fa-solid fa-hand-holding',
				905 => 'fa-solid fa-hand-holding-dollar',
				906 => 'fa-solid fa-hand-holding-droplet',
				907 => 'fa-solid fa-hand-holding-hand',
				908 => 'fa-solid fa-hand-holding-heart',
				909 => 'fa-solid fa-hand-holding-medical',
				910 => 'fa-solid fa-hand-lizard',
				911 => 'fa-regular fa-hand-lizard',
				912 => 'fa-solid fa-hand-middle-finger',
				913 => 'fa-solid fa-hand-peace',
				914 => 'fa-regular fa-hand-peace',
				915 => 'fa-solid fa-hand-point-down',
				916 => 'fa-regular fa-hand-point-down',
				917 => 'fa-solid fa-hand-point-left',
				918 => 'fa-regular fa-hand-point-left',
				919 => 'fa-solid fa-hand-point-right',
				920 => 'fa-regular fa-hand-point-right',
				921 => 'fa-solid fa-hand-point-up',
				922 => 'fa-regular fa-hand-point-up',
				923 => 'fa-solid fa-hand-pointer',
				924 => 'fa-regular fa-hand-pointer',
				925 => 'fa-solid fa-hand-scissors',
				926 => 'fa-regular fa-hand-scissors',
				927 => 'fa-solid fa-hand-sparkles',
				928 => 'fa-solid fa-hand-spock',
				929 => 'fa-regular fa-hand-spock',
				930 => 'fa-solid fa-handcuffs',
				931 => 'fa-solid fa-hands',
				932 => 'fa-solid fa-hands-asl-interpreting',
				933 => 'fa-solid fa-hands-bound',
				934 => 'fa-solid fa-hands-bubbles',
				935 => 'fa-solid fa-hands-clapping',
				936 => 'fa-solid fa-hands-holding',
				937 => 'fa-solid fa-hands-holding-child',
				938 => 'fa-solid fa-hands-holding-circle',
				939 => 'fa-solid fa-hands-praying',
				940 => 'fa-solid fa-handshake',
				941 => 'fa-regular fa-handshake',
				942 => 'fa-solid fa-handshake-angle',
				943 => 'fa-solid fa-handshake-simple',
				944 => 'fa-solid fa-handshake-simple-slash',
				945 => 'fa-solid fa-handshake-slash',
				946 => 'fa-solid fa-hanukiah',
				947 => 'fa-solid fa-hard-drive',
				948 => 'fa-regular fa-hard-drive',
				949 => 'fa-brands fa-hashnode',
				950 => 'fa-solid fa-hashtag',
				951 => 'fa-solid fa-hat-cowboy',
				952 => 'fa-solid fa-hat-cowboy-side',
				953 => 'fa-solid fa-hat-wizard',
				954 => 'fa-solid fa-head-side-cough',
				955 => 'fa-solid fa-head-side-cough-slash',
				956 => 'fa-solid fa-head-side-mask',
				957 => 'fa-solid fa-head-side-virus',
				958 => 'fa-solid fa-heading',
				959 => 'fa-solid fa-headphones',
				960 => 'fa-solid fa-headphones-simple',
				961 => 'fa-solid fa-headset',
				962 => 'fa-solid fa-heart',
				963 => 'fa-regular fa-heart',
				964 => 'fa-solid fa-heart-circle-bolt',
				965 => 'fa-solid fa-heart-circle-check',
				966 => 'fa-solid fa-heart-circle-exclamation',
				967 => 'fa-solid fa-heart-circle-minus',
				968 => 'fa-solid fa-heart-circle-plus',
				969 => 'fa-solid fa-heart-circle-xmark',
				970 => 'fa-solid fa-heart-crack',
				971 => 'fa-solid fa-heart-pulse',
				972 => 'fa-solid fa-helicopter',
				973 => 'fa-solid fa-helicopter-symbol',
				974 => 'fa-solid fa-helmet-safety',
				975 => 'fa-solid fa-helmet-un',
				976 => 'fa-solid fa-highlighter',
				977 => 'fa-solid fa-hill-avalanche',
				978 => 'fa-solid fa-hill-rockslide',
				979 => 'fa-solid fa-hippo',
				980 => 'fa-brands fa-hips',
				981 => 'fa-brands fa-hire-a-helper',
				982 => 'fa-brands fa-hive',
				983 => 'fa-solid fa-hockey-puck',
				984 => 'fa-solid fa-holly-berry',
				985 => 'fa-brands fa-hooli',
				986 => 'fa-brands fa-hornbill',
				987 => 'fa-solid fa-horse',
				988 => 'fa-solid fa-horse-head',
				989 => 'fa-solid fa-hospital',
				990 => 'fa-regular fa-hospital',
				991 => 'fa-solid fa-hospital-user',
				992 => 'fa-solid fa-hot-tub-person',
				993 => 'fa-solid fa-hotdog',
				994 => 'fa-solid fa-hotel',
				995 => 'fa-brands fa-hotjar',
				996 => 'fa-solid fa-hourglass',
				997 => 'fa-regular fa-hourglass',
				998 => 'fa-solid fa-hourglass-empty',
				999 => 'fa-solid fa-hourglass-end',
				1000 => 'fa-solid fa-hourglass-start',
				1001 => 'fa-solid fa-house',
				1002 => 'fa-solid fa-house-chimney',
				1003 => 'fa-solid fa-house-chimney-crack',
				1004 => 'fa-solid fa-house-chimney-medical',
				1005 => 'fa-solid fa-house-chimney-user',
				1006 => 'fa-solid fa-house-chimney-window',
				1007 => 'fa-solid fa-house-circle-check',
				1008 => 'fa-solid fa-house-circle-exclamation',
				1009 => 'fa-solid fa-house-circle-xmark',
				1010 => 'fa-solid fa-house-crack',
				1011 => 'fa-solid fa-house-fire',
				1012 => 'fa-solid fa-house-flag',
				1013 => 'fa-solid fa-house-flood-water',
				1014 => 'fa-solid fa-house-flood-water-circle-arrow-right',
				1015 => 'fa-solid fa-house-laptop',
				1016 => 'fa-solid fa-house-lock',
				1017 => 'fa-solid fa-house-medical',
				1018 => 'fa-solid fa-house-medical-circle-check',
				1019 => 'fa-solid fa-house-medical-circle-exclamation',
				1020 => 'fa-solid fa-house-medical-circle-xmark',
				1021 => 'fa-solid fa-house-medical-flag',
				1022 => 'fa-solid fa-house-signal',
				1023 => 'fa-solid fa-house-tsunami',
				1024 => 'fa-solid fa-house-user',
				1025 => 'fa-brands fa-houzz',
				1026 => 'fa-solid fa-hryvnia-sign',
				1027 => 'fa-brands fa-html5',
				1028 => 'fa-brands fa-hubspot',
				1029 => 'fa-solid fa-hurricane',
				1030 => 'fa-solid fa-i',
				1031 => 'fa-solid fa-i-cursor',
				1032 => 'fa-solid fa-ice-cream',
				1033 => 'fa-solid fa-icicles',
				1034 => 'fa-solid fa-icons',
				1035 => 'fa-solid fa-id-badge',
				1036 => 'fa-regular fa-id-badge',
				1037 => 'fa-solid fa-id-card',
				1038 => 'fa-regular fa-id-card',
				1039 => 'fa-solid fa-id-card-clip',
				1040 => 'fa-brands fa-ideal',
				1041 => 'fa-solid fa-igloo',
				1042 => 'fa-solid fa-image',
				1043 => 'fa-regular fa-image',
				1044 => 'fa-solid fa-image-portrait',
				1045 => 'fa-solid fa-images',
				1046 => 'fa-regular fa-images',
				1047 => 'fa-brands fa-imdb',
				1048 => 'fa-solid fa-inbox',
				1049 => 'fa-solid fa-indent',
				1050 => 'fa-solid fa-indian-rupee-sign',
				1051 => 'fa-solid fa-industry',
				1052 => 'fa-solid fa-infinity',
				1053 => 'fa-solid fa-info',
				1054 => 'fa-brands fa-instagram',
				1055 => 'fa-brands fa-instagram-square',
				1056 => 'fa-brands fa-instalod',
				1057 => 'fa-brands fa-intercom',
				1058 => 'fa-brands fa-internet-explorer',
				1059 => 'fa-brands fa-invision',
				1060 => 'fa-brands fa-ioxhost',
				1061 => 'fa-solid fa-italic',
				1062 => 'fa-brands fa-itch-io',
				1063 => 'fa-brands fa-itunes',
				1064 => 'fa-brands fa-itunes-note',
				1065 => 'fa-solid fa-j',
				1066 => 'fa-solid fa-jar',
				1067 => 'fa-solid fa-jar-wheat',
				1068 => 'fa-brands fa-java',
				1069 => 'fa-solid fa-jedi',
				1070 => 'fa-brands fa-jedi-order',
				1071 => 'fa-brands fa-jenkins',
				1072 => 'fa-solid fa-jet-fighter',
				1073 => 'fa-solid fa-jet-fighter-up',
				1074 => 'fa-brands fa-jira',
				1075 => 'fa-brands fa-joget',
				1076 => 'fa-solid fa-joint',
				1077 => 'fa-brands fa-joomla',
				1078 => 'fa-brands fa-js',
				1079 => 'fa-brands fa-js-square',
				1080 => 'fa-brands fa-jsfiddle',
				1081 => 'fa-solid fa-jug-detergent',
				1082 => 'fa-solid fa-k',
				1083 => 'fa-solid fa-kaaba',
				1084 => 'fa-brands fa-kaggle',
				1085 => 'fa-solid fa-key',
				1086 => 'fa-brands fa-keybase',
				1087 => 'fa-solid fa-keyboard',
				1088 => 'fa-regular fa-keyboard',
				1089 => 'fa-brands fa-keycdn',
				1090 => 'fa-solid fa-khanda',
				1091 => 'fa-brands fa-kickstarter',
				1092 => 'fa-brands fa-kickstarter-k',
				1093 => 'fa-solid fa-kip-sign',
				1094 => 'fa-solid fa-kit-medical',
				1095 => 'fa-solid fa-kitchen-set',
				1096 => 'fa-solid fa-kiwi-bird',
				1097 => 'fa-brands fa-korvue',
				1098 => 'fa-solid fa-l',
				1099 => 'fa-solid fa-land-mine-on',
				1100 => 'fa-solid fa-landmark',
				1101 => 'fa-solid fa-landmark-dome',
				1102 => 'fa-solid fa-landmark-flag',
				1103 => 'fa-solid fa-language',
				1104 => 'fa-solid fa-laptop',
				1105 => 'fa-solid fa-laptop-code',
				1106 => 'fa-solid fa-laptop-file',
				1107 => 'fa-solid fa-laptop-medical',
				1108 => 'fa-brands fa-laravel',
				1109 => 'fa-solid fa-lari-sign',
				1110 => 'fa-brands fa-lastfm',
				1111 => 'fa-brands fa-lastfm-square',
				1112 => 'fa-solid fa-layer-group',
				1113 => 'fa-solid fa-leaf',
				1114 => 'fa-brands fa-leanpub',
				1115 => 'fa-solid fa-left-long',
				1116 => 'fa-solid fa-left-right',
				1117 => 'fa-solid fa-lemon',
				1118 => 'fa-regular fa-lemon',
				1119 => 'fa-brands fa-less',
				1120 => 'fa-solid fa-less-than',
				1121 => 'fa-solid fa-less-than-equal',
				1122 => 'fa-solid fa-life-ring',
				1123 => 'fa-regular fa-life-ring',
				1124 => 'fa-solid fa-lightbulb',
				1125 => 'fa-regular fa-lightbulb',
				1126 => 'fa-brands fa-line',
				1127 => 'fa-solid fa-lines-leaning',
				1128 => 'fa-solid fa-link',
				1129 => 'fa-solid fa-link-slash',
				1130 => 'fa-brands fa-linkedin',
				1131 => 'fa-brands fa-linkedin-in',
				1132 => 'fa-brands fa-linode',
				1133 => 'fa-brands fa-linux',
				1134 => 'fa-solid fa-lira-sign',
				1135 => 'fa-solid fa-list',
				1136 => 'fa-solid fa-list-check',
				1137 => 'fa-solid fa-list-ol',
				1138 => 'fa-solid fa-list-ul',
				1139 => 'fa-solid fa-litecoin-sign',
				1140 => 'fa-solid fa-location-arrow',
				1141 => 'fa-solid fa-location-crosshairs',
				1142 => 'fa-solid fa-location-dot',
				1143 => 'fa-solid fa-location-pin',
				1144 => 'fa-solid fa-location-pin-lock',
				1145 => 'fa-solid fa-lock',
				1146 => 'fa-solid fa-lock-open',
				1147 => 'fa-solid fa-locust',
				1148 => 'fa-solid fa-lungs',
				1149 => 'fa-solid fa-lungs-virus',
				1150 => 'fa-brands fa-lyft',
				1151 => 'fa-solid fa-m',
				1152 => 'fa-brands fa-magento',
				1153 => 'fa-solid fa-magnet',
				1154 => 'fa-solid fa-magnifying-glass',
				1155 => 'fa-solid fa-magnifying-glass-arrow-right',
				1156 => 'fa-solid fa-magnifying-glass-chart',
				1157 => 'fa-solid fa-magnifying-glass-dollar',
				1158 => 'fa-solid fa-magnifying-glass-location',
				1159 => 'fa-solid fa-magnifying-glass-minus',
				1160 => 'fa-solid fa-magnifying-glass-plus',
				1161 => 'fa-brands fa-mailchimp',
				1162 => 'fa-solid fa-manat-sign',
				1163 => 'fa-brands fa-mandalorian',
				1164 => 'fa-solid fa-map',
				1165 => 'fa-regular fa-map',
				1166 => 'fa-solid fa-map-location',
				1167 => 'fa-solid fa-map-location-dot',
				1168 => 'fa-solid fa-map-pin',
				1169 => 'fa-brands fa-markdown',
				1170 => 'fa-solid fa-marker',
				1171 => 'fa-solid fa-mars',
				1172 => 'fa-solid fa-mars-and-venus',
				1173 => 'fa-solid fa-mars-and-venus-burst',
				1174 => 'fa-solid fa-mars-double',
				1175 => 'fa-solid fa-mars-stroke',
				1176 => 'fa-solid fa-mars-stroke-right',
				1177 => 'fa-solid fa-mars-stroke-up',
				1178 => 'fa-solid fa-martini-glass',
				1179 => 'fa-solid fa-martini-glass-citrus',
				1180 => 'fa-solid fa-martini-glass-empty',
				1181 => 'fa-solid fa-mask',
				1182 => 'fa-solid fa-mask-face',
				1183 => 'fa-solid fa-mask-ventilator',
				1184 => 'fa-solid fa-masks-theater',
				1185 => 'fa-brands fa-mastodon',
				1186 => 'fa-solid fa-mattress-pillow',
				1187 => 'fa-brands fa-maxcdn',
				1188 => 'fa-solid fa-maximize',
				1189 => 'fa-brands fa-mdb',
				1190 => 'fa-solid fa-medal',
				1191 => 'fa-brands fa-medapps',
				1192 => 'fa-brands fa-medium',
				1193 => 'fa-brands fa-medrt',
				1194 => 'fa-brands fa-meetup',
				1195 => 'fa-brands fa-megaport',
				1196 => 'fa-solid fa-memory',
				1197 => 'fa-brands fa-mendeley',
				1198 => 'fa-solid fa-menorah',
				1199 => 'fa-solid fa-mercury',
				1200 => 'fa-solid fa-message',
				1201 => 'fa-regular fa-message',
				1202 => 'fa-solid fa-meteor',
				1203 => 'fa-brands fa-microblog',
				1204 => 'fa-solid fa-microchip',
				1205 => 'fa-solid fa-microphone',
				1206 => 'fa-solid fa-microphone-lines',
				1207 => 'fa-solid fa-microphone-lines-slash',
				1208 => 'fa-solid fa-microphone-slash',
				1209 => 'fa-solid fa-microscope',
				1210 => 'fa-brands fa-microsoft',
				1211 => 'fa-solid fa-mill-sign',
				1212 => 'fa-solid fa-minimize',
				1213 => 'fa-solid fa-minus',
				1214 => 'fa-solid fa-mitten',
				1215 => 'fa-brands fa-mix',
				1216 => 'fa-brands fa-mixcloud',
				1217 => 'fa-brands fa-mixer',
				1218 => 'fa-brands fa-mizuni',
				1219 => 'fa-solid fa-mobile',
				1220 => 'fa-solid fa-mobile-button',
				1221 => 'fa-solid fa-mobile-retro',
				1222 => 'fa-solid fa-mobile-screen',
				1223 => 'fa-solid fa-mobile-screen-button',
				1224 => 'fa-brands fa-modx',
				1225 => 'fa-brands fa-monero',
				1226 => 'fa-solid fa-money-bill',
				1227 => 'fa-solid fa-money-bill-1',
				1228 => 'fa-regular fa-money-bill-1',
				1229 => 'fa-solid fa-money-bill-1-wave',
				1230 => 'fa-solid fa-money-bill-transfer',
				1231 => 'fa-solid fa-money-bill-trend-up',
				1232 => 'fa-solid fa-money-bill-wave',
				1233 => 'fa-solid fa-money-bill-wheat',
				1234 => 'fa-solid fa-money-bills',
				1235 => 'fa-solid fa-money-check',
				1236 => 'fa-solid fa-money-check-dollar',
				1237 => 'fa-solid fa-monument',
				1238 => 'fa-solid fa-moon',
				1239 => 'fa-regular fa-moon',
				1240 => 'fa-solid fa-mortar-pestle',
				1241 => 'fa-solid fa-mosque',
				1242 => 'fa-solid fa-mosquito',
				1243 => 'fa-solid fa-mosquito-net',
				1244 => 'fa-solid fa-motorcycle',
				1245 => 'fa-solid fa-mound',
				1246 => 'fa-solid fa-mountain',
				1247 => 'fa-solid fa-mountain-city',
				1248 => 'fa-solid fa-mountain-sun',
				1249 => 'fa-solid fa-mug-hot',
				1250 => 'fa-solid fa-mug-saucer',
				1251 => 'fa-solid fa-music',
				1252 => 'fa-solid fa-n',
				1253 => 'fa-solid fa-naira-sign',
				1254 => 'fa-brands fa-napster',
				1255 => 'fa-brands fa-neos',
				1256 => 'fa-solid fa-network-wired',
				1257 => 'fa-solid fa-neuter',
				1258 => 'fa-solid fa-newspaper',
				1259 => 'fa-regular fa-newspaper',
				1260 => 'fa-brands fa-nfc-directional',
				1261 => 'fa-brands fa-nfc-symbol',
				1262 => 'fa-brands fa-nimblr',
				1263 => 'fa-brands fa-node',
				1264 => 'fa-brands fa-node-js',
				1265 => 'fa-solid fa-not-equal',
				1266 => 'fa-solid fa-note-sticky',
				1267 => 'fa-regular fa-note-sticky',
				1268 => 'fa-solid fa-notes-medical',
				1269 => 'fa-brands fa-npm',
				1270 => 'fa-brands fa-ns8',
				1271 => 'fa-brands fa-nutritionix',
				1272 => 'fa-solid fa-o',
				1273 => 'fa-solid fa-object-group',
				1274 => 'fa-regular fa-object-group',
				1275 => 'fa-solid fa-object-ungroup',
				1276 => 'fa-regular fa-object-ungroup',
				1277 => 'fa-brands fa-octopus-deploy',
				1278 => 'fa-brands fa-odnoklassniki',
				1279 => 'fa-brands fa-odnoklassniki-square',
				1280 => 'fa-solid fa-oil-can',
				1281 => 'fa-solid fa-oil-well',
				1282 => 'fa-brands fa-old-republic',
				1283 => 'fa-solid fa-om',
				1284 => 'fa-brands fa-opencart',
				1285 => 'fa-brands fa-openid',
				1286 => 'fa-brands fa-opera',
				1287 => 'fa-brands fa-optin-monster',
				1288 => 'fa-brands fa-orcid',
				1289 => 'fa-brands fa-osi',
				1290 => 'fa-solid fa-otter',
				1291 => 'fa-solid fa-outdent',
				1292 => 'fa-solid fa-p',
				1293 => 'fa-brands fa-padlet',
				1294 => 'fa-brands fa-page4',
				1295 => 'fa-brands fa-pagelines',
				1296 => 'fa-solid fa-pager',
				1297 => 'fa-solid fa-paint-roller',
				1298 => 'fa-solid fa-paintbrush',
				1299 => 'fa-solid fa-palette',
				1300 => 'fa-brands fa-palfed',
				1301 => 'fa-solid fa-pallet',
				1302 => 'fa-solid fa-panorama',
				1303 => 'fa-solid fa-paper-plane',
				1304 => 'fa-regular fa-paper-plane',
				1305 => 'fa-solid fa-paperclip',
				1306 => 'fa-solid fa-parachute-box',
				1307 => 'fa-solid fa-paragraph',
				1308 => 'fa-solid fa-passport',
				1309 => 'fa-solid fa-paste',
				1310 => 'fa-regular fa-paste',
				1311 => 'fa-brands fa-patreon',
				1312 => 'fa-solid fa-pause',
				1313 => 'fa-solid fa-paw',
				1314 => 'fa-brands fa-paypal',
				1315 => 'fa-solid fa-peace',
				1316 => 'fa-solid fa-pen',
				1317 => 'fa-solid fa-pen-clip',
				1318 => 'fa-solid fa-pen-fancy',
				1319 => 'fa-solid fa-pen-nib',
				1320 => 'fa-solid fa-pen-ruler',
				1321 => 'fa-solid fa-pen-to-square',
				1322 => 'fa-regular fa-pen-to-square',
				1323 => 'fa-solid fa-pencil',
				1324 => 'fa-solid fa-people-arrows-left-right',
				1325 => 'fa-solid fa-people-carry-box',
				1326 => 'fa-solid fa-people-group',
				1327 => 'fa-solid fa-people-line',
				1328 => 'fa-solid fa-people-pulling',
				1329 => 'fa-solid fa-people-robbery',
				1330 => 'fa-solid fa-people-roof',
				1331 => 'fa-solid fa-pepper-hot',
				1332 => 'fa-brands fa-perbyte',
				1333 => 'fa-solid fa-percent',
				1334 => 'fa-brands fa-periscope',
				1335 => 'fa-solid fa-person',
				1336 => 'fa-solid fa-person-arrow-down-to-line',
				1337 => 'fa-solid fa-person-arrow-up-from-line',
				1338 => 'fa-solid fa-person-biking',
				1339 => 'fa-solid fa-person-booth',
				1340 => 'fa-solid fa-person-breastfeeding',
				1341 => 'fa-solid fa-person-burst',
				1342 => 'fa-solid fa-person-cane',
				1343 => 'fa-solid fa-person-chalkboard',
				1344 => 'fa-solid fa-person-circle-check',
				1345 => 'fa-solid fa-person-circle-exclamation',
				1346 => 'fa-solid fa-person-circle-minus',
				1347 => 'fa-solid fa-person-circle-plus',
				1348 => 'fa-solid fa-person-circle-question',
				1349 => 'fa-solid fa-person-circle-xmark',
				1350 => 'fa-solid fa-person-digging',
				1351 => 'fa-solid fa-person-dots-from-line',
				1352 => 'fa-solid fa-person-dress',
				1353 => 'fa-solid fa-person-dress-burst',
				1354 => 'fa-solid fa-person-drowning',
				1355 => 'fa-solid fa-person-falling',
				1356 => 'fa-solid fa-person-falling-burst',
				1357 => 'fa-solid fa-person-half-dress',
				1358 => 'fa-solid fa-person-harassing',
				1359 => 'fa-solid fa-person-hiking',
				1360 => 'fa-solid fa-person-military-pointing',
				1361 => 'fa-solid fa-person-military-rifle',
				1362 => 'fa-solid fa-person-military-to-person',
				1363 => 'fa-solid fa-person-praying',
				1364 => 'fa-solid fa-person-pregnant',
				1365 => 'fa-solid fa-person-rays',
				1366 => 'fa-solid fa-person-rifle',
				1367 => 'fa-solid fa-person-running',
				1368 => 'fa-solid fa-person-shelter',
				1369 => 'fa-solid fa-person-skating',
				1370 => 'fa-solid fa-person-skiing',
				1371 => 'fa-solid fa-person-skiing-nordic',
				1372 => 'fa-solid fa-person-snowboarding',
				1373 => 'fa-solid fa-person-swimming',
				1374 => 'fa-solid fa-person-through-window',
				1375 => 'fa-solid fa-person-walking',
				1376 => 'fa-solid fa-person-walking-arrow-loop-left',
				1377 => 'fa-solid fa-person-walking-arrow-right',
				1378 => 'fa-solid fa-person-walking-dashed-line-arrow-right',
				1379 => 'fa-solid fa-person-walking-luggage',
				1380 => 'fa-solid fa-person-walking-with-cane',
				1381 => 'fa-solid fa-peseta-sign',
				1382 => 'fa-solid fa-peso-sign',
				1383 => 'fa-brands fa-phabricator',
				1384 => 'fa-brands fa-phoenix-framework',
				1385 => 'fa-brands fa-phoenix-squadron',
				1386 => 'fa-solid fa-phone',
				1387 => 'fa-solid fa-phone-flip',
				1388 => 'fa-solid fa-phone-slash',
				1389 => 'fa-solid fa-phone-volume',
				1390 => 'fa-solid fa-photo-film',
				1391 => 'fa-brands fa-php',
				1392 => 'fa-brands fa-pied-piper',
				1393 => 'fa-brands fa-pied-piper-alt',
				1394 => 'fa-brands fa-pied-piper-hat',
				1395 => 'fa-brands fa-pied-piper-pp',
				1396 => 'fa-brands fa-pied-piper-square',
				1397 => 'fa-solid fa-piggy-bank',
				1398 => 'fa-solid fa-pills',
				1399 => 'fa-brands fa-pinterest',
				1400 => 'fa-brands fa-pinterest-p',
				1401 => 'fa-brands fa-pinterest-square',
				1402 => 'fa-brands fa-pix',
				1403 => 'fa-solid fa-pizza-slice',
				1404 => 'fa-solid fa-place-of-worship',
				1405 => 'fa-solid fa-plane',
				1406 => 'fa-solid fa-plane-arrival',
				1407 => 'fa-solid fa-plane-circle-check',
				1408 => 'fa-solid fa-plane-circle-exclamation',
				1409 => 'fa-solid fa-plane-circle-xmark',
				1410 => 'fa-solid fa-plane-departure',
				1411 => 'fa-solid fa-plane-lock',
				1412 => 'fa-solid fa-plane-slash',
				1413 => 'fa-solid fa-plane-up',
				1414 => 'fa-solid fa-plant-wilt',
				1415 => 'fa-solid fa-plate-wheat',
				1416 => 'fa-solid fa-play',
				1417 => 'fa-brands fa-playstation',
				1418 => 'fa-solid fa-plug',
				1419 => 'fa-solid fa-plug-circle-bolt',
				1420 => 'fa-solid fa-plug-circle-check',
				1421 => 'fa-solid fa-plug-circle-exclamation',
				1422 => 'fa-solid fa-plug-circle-minus',
				1423 => 'fa-solid fa-plug-circle-plus',
				1424 => 'fa-solid fa-plug-circle-xmark',
				1425 => 'fa-solid fa-plus',
				1426 => 'fa-solid fa-plus-minus',
				1427 => 'fa-solid fa-podcast',
				1428 => 'fa-solid fa-poo',
				1429 => 'fa-solid fa-poo-storm',
				1430 => 'fa-solid fa-poop',
				1431 => 'fa-solid fa-power-off',
				1432 => 'fa-solid fa-prescription',
				1433 => 'fa-solid fa-prescription-bottle',
				1434 => 'fa-solid fa-prescription-bottle-medical',
				1435 => 'fa-solid fa-print',
				1436 => 'fa-brands fa-product-hunt',
				1437 => 'fa-solid fa-pump-medical',
				1438 => 'fa-solid fa-pump-soap',
				1439 => 'fa-brands fa-pushed',
				1440 => 'fa-solid fa-puzzle-piece',
				1441 => 'fa-brands fa-python',
				1442 => 'fa-solid fa-q',
				1443 => 'fa-brands fa-qq',
				1444 => 'fa-solid fa-qrcode',
				1445 => 'fa-solid fa-question',
				1446 => 'fa-brands fa-quinscape',
				1447 => 'fa-brands fa-quora',
				1448 => 'fa-solid fa-quote-left',
				1449 => 'fa-solid fa-quote-right',
				1450 => 'fa-solid fa-r',
				1451 => 'fa-brands fa-r-project',
				1452 => 'fa-solid fa-radiation',
				1453 => 'fa-solid fa-radio',
				1454 => 'fa-solid fa-rainbow',
				1455 => 'fa-solid fa-ranking-star',
				1456 => 'fa-brands fa-raspberry-pi',
				1457 => 'fa-brands fa-ravelry',
				1458 => 'fa-brands fa-react',
				1459 => 'fa-brands fa-reacteurope',
				1460 => 'fa-brands fa-readme',
				1461 => 'fa-brands fa-rebel',
				1462 => 'fa-solid fa-receipt',
				1463 => 'fa-solid fa-record-vinyl',
				1464 => 'fa-solid fa-rectangle-ad',
				1465 => 'fa-solid fa-rectangle-list',
				1466 => 'fa-regular fa-rectangle-list',
				1467 => 'fa-solid fa-rectangle-xmark',
				1468 => 'fa-regular fa-rectangle-xmark',
				1469 => 'fa-solid fa-recycle',
				1470 => 'fa-brands fa-red-river',
				1471 => 'fa-brands fa-reddit',
				1472 => 'fa-brands fa-reddit-alien',
				1473 => 'fa-brands fa-reddit-square',
				1474 => 'fa-brands fa-redhat',
				1475 => 'fa-solid fa-registered',
				1476 => 'fa-regular fa-registered',
				1477 => 'fa-brands fa-renren',
				1478 => 'fa-solid fa-repeat',
				1479 => 'fa-solid fa-reply',
				1480 => 'fa-solid fa-reply-all',
				1481 => 'fa-brands fa-replyd',
				1482 => 'fa-solid fa-republican',
				1483 => 'fa-brands fa-researchgate',
				1484 => 'fa-brands fa-resolving',
				1485 => 'fa-solid fa-restroom',
				1486 => 'fa-solid fa-retweet',
				1487 => 'fa-brands fa-rev',
				1488 => 'fa-solid fa-ribbon',
				1489 => 'fa-solid fa-right-from-bracket',
				1490 => 'fa-solid fa-right-left',
				1491 => 'fa-solid fa-right-long',
				1492 => 'fa-solid fa-right-to-bracket',
				1493 => 'fa-solid fa-ring',
				1494 => 'fa-solid fa-road',
				1495 => 'fa-solid fa-road-barrier',
				1496 => 'fa-solid fa-road-bridge',
				1497 => 'fa-solid fa-road-circle-check',
				1498 => 'fa-solid fa-road-circle-exclamation',
				1499 => 'fa-solid fa-road-circle-xmark',
				1500 => 'fa-solid fa-road-lock',
				1501 => 'fa-solid fa-road-spikes',
				1502 => 'fa-solid fa-robot',
				1503 => 'fa-solid fa-rocket',
				1504 => 'fa-brands fa-rocketchat',
				1505 => 'fa-brands fa-rockrms',
				1506 => 'fa-solid fa-rotate',
				1507 => 'fa-solid fa-rotate-left',
				1508 => 'fa-solid fa-rotate-right',
				1509 => 'fa-solid fa-route',
				1510 => 'fa-solid fa-rss',
				1511 => 'fa-solid fa-ruble-sign',
				1512 => 'fa-solid fa-rug',
				1513 => 'fa-solid fa-ruler',
				1514 => 'fa-solid fa-ruler-combined',
				1515 => 'fa-solid fa-ruler-horizontal',
				1516 => 'fa-solid fa-ruler-vertical',
				1517 => 'fa-solid fa-rupee-sign',
				1518 => 'fa-solid fa-rupiah-sign',
				1519 => 'fa-brands fa-rust',
				1520 => 'fa-solid fa-s',
				1521 => 'fa-solid fa-sack-dollar',
				1522 => 'fa-solid fa-sack-xmark',
				1523 => 'fa-brands fa-safari',
				1524 => 'fa-solid fa-sailboat',
				1525 => 'fa-brands fa-salesforce',
				1526 => 'fa-brands fa-sass',
				1527 => 'fa-solid fa-satellite',
				1528 => 'fa-solid fa-satellite-dish',
				1529 => 'fa-solid fa-scale-balanced',
				1530 => 'fa-solid fa-scale-unbalanced',
				1531 => 'fa-solid fa-scale-unbalanced-flip',
				1532 => 'fa-brands fa-schlix',
				1533 => 'fa-solid fa-school',
				1534 => 'fa-solid fa-school-circle-check',
				1535 => 'fa-solid fa-school-circle-exclamation',
				1536 => 'fa-solid fa-school-circle-xmark',
				1537 => 'fa-solid fa-school-flag',
				1538 => 'fa-solid fa-school-lock',
				1539 => 'fa-solid fa-scissors',
				1540 => 'fa-brands fa-screenpal',
				1541 => 'fa-solid fa-screwdriver',
				1542 => 'fa-solid fa-screwdriver-wrench',
				1543 => 'fa-brands fa-scribd',
				1544 => 'fa-solid fa-scroll',
				1545 => 'fa-solid fa-scroll-torah',
				1546 => 'fa-solid fa-sd-card',
				1547 => 'fa-brands fa-searchengin',
				1548 => 'fa-solid fa-section',
				1549 => 'fa-solid fa-seedling',
				1550 => 'fa-brands fa-sellcast',
				1551 => 'fa-brands fa-sellsy',
				1552 => 'fa-solid fa-server',
				1553 => 'fa-brands fa-servicestack',
				1554 => 'fa-solid fa-shapes',
				1555 => 'fa-solid fa-share',
				1556 => 'fa-solid fa-share-from-square',
				1557 => 'fa-regular fa-share-from-square',
				1558 => 'fa-solid fa-share-nodes',
				1559 => 'fa-solid fa-sheet-plastic',
				1560 => 'fa-solid fa-shekel-sign',
				1561 => 'fa-solid fa-shield',
				1562 => 'fa-solid fa-shield-cat',
				1563 => 'fa-solid fa-shield-dog',
				1564 => 'fa-solid fa-shield-halved',
				1565 => 'fa-solid fa-shield-heart',
				1566 => 'fa-solid fa-shield-virus',
				1567 => 'fa-solid fa-ship',
				1568 => 'fa-solid fa-shirt',
				1569 => 'fa-brands fa-shirtsinbulk',
				1570 => 'fa-solid fa-shoe-prints',
				1571 => 'fa-solid fa-shop',
				1572 => 'fa-solid fa-shop-lock',
				1573 => 'fa-solid fa-shop-slash',
				1574 => 'fa-brands fa-shopify',
				1575 => 'fa-brands fa-shopware',
				1576 => 'fa-solid fa-shower',
				1577 => 'fa-solid fa-shrimp',
				1578 => 'fa-solid fa-shuffle',
				1579 => 'fa-solid fa-shuttle-space',
				1580 => 'fa-solid fa-sign-hanging',
				1581 => 'fa-solid fa-signal',
				1582 => 'fa-solid fa-signature',
				1583 => 'fa-solid fa-signs-post',
				1584 => 'fa-solid fa-sim-card',
				1585 => 'fa-brands fa-simplybuilt',
				1586 => 'fa-solid fa-sink',
				1587 => 'fa-brands fa-sistrix',
				1588 => 'fa-solid fa-sitemap',
				1589 => 'fa-brands fa-sith',
				1590 => 'fa-brands fa-sitrox',
				1591 => 'fa-brands fa-sketch',
				1592 => 'fa-solid fa-skull',
				1593 => 'fa-solid fa-skull-crossbones',
				1594 => 'fa-brands fa-skyatlas',
				1595 => 'fa-brands fa-skype',
				1596 => 'fa-brands fa-slack',
				1597 => 'fa-solid fa-slash',
				1598 => 'fa-solid fa-sleigh',
				1599 => 'fa-solid fa-sliders',
				1600 => 'fa-brands fa-slideshare',
				1601 => 'fa-solid fa-smog',
				1602 => 'fa-solid fa-smoking',
				1603 => 'fa-brands fa-snapchat',
				1604 => 'fa-brands fa-snapchat-square',
				1605 => 'fa-solid fa-snowflake',
				1606 => 'fa-regular fa-snowflake',
				1607 => 'fa-solid fa-snowman',
				1608 => 'fa-solid fa-snowplow',
				1609 => 'fa-solid fa-soap',
				1610 => 'fa-solid fa-socks',
				1611 => 'fa-solid fa-solar-panel',
				1612 => 'fa-solid fa-sort',
				1613 => 'fa-solid fa-sort-down',
				1614 => 'fa-solid fa-sort-up',
				1615 => 'fa-brands fa-soundcloud',
				1616 => 'fa-brands fa-sourcetree',
				1617 => 'fa-solid fa-spa',
				1618 => 'fa-solid fa-spaghetti-monster-flying',
				1619 => 'fa-brands fa-speakap',
				1620 => 'fa-brands fa-speaker-deck',
				1621 => 'fa-solid fa-spell-check',
				1622 => 'fa-solid fa-spider',
				1623 => 'fa-solid fa-spinner',
				1624 => 'fa-solid fa-splotch',
				1625 => 'fa-solid fa-spoon',
				1626 => 'fa-brands fa-spotify',
				1627 => 'fa-solid fa-spray-can',
				1628 => 'fa-solid fa-spray-can-sparkles',
				1629 => 'fa-solid fa-square',
				1630 => 'fa-regular fa-square',
				1631 => 'fa-solid fa-square-arrow-up-right',
				1632 => 'fa-solid fa-square-caret-down',
				1633 => 'fa-regular fa-square-caret-down',
				1634 => 'fa-solid fa-square-caret-left',
				1635 => 'fa-regular fa-square-caret-left',
				1636 => 'fa-solid fa-square-caret-right',
				1637 => 'fa-regular fa-square-caret-right',
				1638 => 'fa-solid fa-square-caret-up',
				1639 => 'fa-regular fa-square-caret-up',
				1640 => 'fa-solid fa-square-check',
				1641 => 'fa-regular fa-square-check',
				1642 => 'fa-solid fa-square-envelope',
				1643 => 'fa-brands fa-square-font-awesome',
				1644 => 'fa-brands fa-square-font-awesome-stroke',
				1645 => 'fa-solid fa-square-full',
				1646 => 'fa-regular fa-square-full',
				1647 => 'fa-solid fa-square-h',
				1648 => 'fa-solid fa-square-minus',
				1649 => 'fa-regular fa-square-minus',
				1650 => 'fa-solid fa-square-nfi',
				1651 => 'fa-solid fa-square-parking',
				1652 => 'fa-solid fa-square-pen',
				1653 => 'fa-solid fa-square-person-confined',
				1654 => 'fa-solid fa-square-phone',
				1655 => 'fa-solid fa-square-phone-flip',
				1656 => 'fa-solid fa-square-plus',
				1657 => 'fa-regular fa-square-plus',
				1658 => 'fa-solid fa-square-poll-horizontal',
				1659 => 'fa-solid fa-square-poll-vertical',
				1660 => 'fa-solid fa-square-root-variable',
				1661 => 'fa-solid fa-square-rss',
				1662 => 'fa-solid fa-square-share-nodes',
				1663 => 'fa-solid fa-square-up-right',
				1664 => 'fa-solid fa-square-virus',
				1665 => 'fa-solid fa-square-xmark',
				1666 => 'fa-brands fa-squarespace',
				1667 => 'fa-brands fa-stack-exchange',
				1668 => 'fa-brands fa-stack-overflow',
				1669 => 'fa-brands fa-stackpath',
				1670 => 'fa-solid fa-staff-aesculapius',
				1671 => 'fa-solid fa-stairs',
				1672 => 'fa-solid fa-stamp',
				1673 => 'fa-solid fa-star',
				1674 => 'fa-regular fa-star',
				1675 => 'fa-solid fa-star-and-crescent',
				1676 => 'fa-solid fa-star-half',
				1677 => 'fa-regular fa-star-half',
				1678 => 'fa-solid fa-star-half-stroke',
				1679 => 'fa-regular fa-star-half-stroke',
				1680 => 'fa-solid fa-star-of-david',
				1681 => 'fa-solid fa-star-of-life',
				1682 => 'fa-brands fa-staylinked',
				1683 => 'fa-brands fa-steam',
				1684 => 'fa-brands fa-steam-square',
				1685 => 'fa-brands fa-steam-symbol',
				1686 => 'fa-solid fa-sterling-sign',
				1687 => 'fa-solid fa-stethoscope',
				1688 => 'fa-brands fa-sticker-mule',
				1689 => 'fa-solid fa-stop',
				1690 => 'fa-solid fa-stopwatch',
				1691 => 'fa-solid fa-stopwatch-20',
				1692 => 'fa-solid fa-store',
				1693 => 'fa-solid fa-store-slash',
				1694 => 'fa-brands fa-strava',
				1695 => 'fa-solid fa-street-view',
				1696 => 'fa-solid fa-strikethrough',
				1697 => 'fa-brands fa-stripe',
				1698 => 'fa-brands fa-stripe-s',
				1699 => 'fa-solid fa-stroopwafel',
				1700 => 'fa-brands fa-studiovinari',
				1701 => 'fa-brands fa-stumbleupon',
				1702 => 'fa-brands fa-stumbleupon-circle',
				1703 => 'fa-solid fa-subscript',
				1704 => 'fa-solid fa-suitcase',
				1705 => 'fa-solid fa-suitcase-medical',
				1706 => 'fa-solid fa-suitcase-rolling',
				1707 => 'fa-solid fa-sun',
				1708 => 'fa-regular fa-sun',
				1709 => 'fa-solid fa-sun-plant-wilt',
				1710 => 'fa-brands fa-superpowers',
				1711 => 'fa-solid fa-superscript',
				1712 => 'fa-brands fa-supple',
				1713 => 'fa-brands fa-suse',
				1714 => 'fa-solid fa-swatchbook',
				1715 => 'fa-brands fa-swift',
				1716 => 'fa-brands fa-symfony',
				1717 => 'fa-solid fa-synagogue',
				1718 => 'fa-solid fa-syringe',
				1719 => 'fa-solid fa-t',
				1720 => 'fa-solid fa-table',
				1721 => 'fa-solid fa-table-cells',
				1722 => 'fa-solid fa-table-cells-large',
				1723 => 'fa-solid fa-table-columns',
				1724 => 'fa-solid fa-table-list',
				1725 => 'fa-solid fa-table-tennis-paddle-ball',
				1726 => 'fa-solid fa-tablet',
				1727 => 'fa-solid fa-tablet-button',
				1728 => 'fa-solid fa-tablet-screen-button',
				1729 => 'fa-solid fa-tablets',
				1730 => 'fa-solid fa-tachograph-digital',
				1731 => 'fa-solid fa-tag',
				1732 => 'fa-solid fa-tags',
				1733 => 'fa-solid fa-tape',
				1734 => 'fa-solid fa-tarp',
				1735 => 'fa-solid fa-tarp-droplet',
				1736 => 'fa-solid fa-taxi',
				1737 => 'fa-brands fa-teamspeak',
				1738 => 'fa-solid fa-teeth',
				1739 => 'fa-solid fa-teeth-open',
				1740 => 'fa-brands fa-telegram',
				1741 => 'fa-solid fa-temperature-arrow-down',
				1742 => 'fa-solid fa-temperature-arrow-up',
				1743 => 'fa-solid fa-temperature-empty',
				1744 => 'fa-solid fa-temperature-full',
				1745 => 'fa-solid fa-temperature-half',
				1746 => 'fa-solid fa-temperature-high',
				1747 => 'fa-solid fa-temperature-low',
				1748 => 'fa-solid fa-temperature-quarter',
				1749 => 'fa-solid fa-temperature-three-quarters',
				1750 => 'fa-brands fa-tencent-weibo',
				1751 => 'fa-solid fa-tenge-sign',
				1752 => 'fa-solid fa-tent',
				1753 => 'fa-solid fa-tent-arrow-down-to-line',
				1754 => 'fa-solid fa-tent-arrow-left-right',
				1755 => 'fa-solid fa-tent-arrow-turn-left',
				1756 => 'fa-solid fa-tent-arrows-down',
				1757 => 'fa-solid fa-tents',
				1758 => 'fa-solid fa-terminal',
				1759 => 'fa-solid fa-text-height',
				1760 => 'fa-solid fa-text-slash',
				1761 => 'fa-solid fa-text-width',
				1762 => 'fa-brands fa-the-red-yeti',
				1763 => 'fa-brands fa-themeco',
				1764 => 'fa-brands fa-themeisle',
				1765 => 'fa-solid fa-thermometer',
				1766 => 'fa-brands fa-think-peaks',
				1767 => 'fa-solid fa-thumbs-down',
				1768 => 'fa-regular fa-thumbs-down',
				1769 => 'fa-solid fa-thumbs-up',
				1770 => 'fa-regular fa-thumbs-up',
				1771 => 'fa-solid fa-thumbtack',
				1772 => 'fa-solid fa-ticket',
				1773 => 'fa-solid fa-ticket-simple',
				1774 => 'fa-brands fa-tiktok',
				1775 => 'fa-solid fa-timeline',
				1776 => 'fa-solid fa-toggle-off',
				1777 => 'fa-solid fa-toggle-on',
				1778 => 'fa-solid fa-toilet',
				1779 => 'fa-solid fa-toilet-paper',
				1780 => 'fa-solid fa-toilet-paper-slash',
				1781 => 'fa-solid fa-toilet-portable',
				1782 => 'fa-solid fa-toilets-portable',
				1783 => 'fa-solid fa-toolbox',
				1784 => 'fa-solid fa-tooth',
				1785 => 'fa-solid fa-torii-gate',
				1786 => 'fa-solid fa-tornado',
				1787 => 'fa-solid fa-tower-broadcast',
				1788 => 'fa-solid fa-tower-cell',
				1789 => 'fa-solid fa-tower-observation',
				1790 => 'fa-solid fa-tractor',
				1791 => 'fa-brands fa-trade-federation',
				1792 => 'fa-solid fa-trademark',
				1793 => 'fa-solid fa-traffic-light',
				1794 => 'fa-solid fa-trailer',
				1795 => 'fa-solid fa-train',
				1796 => 'fa-solid fa-train-subway',
				1797 => 'fa-solid fa-train-tram',
				1798 => 'fa-solid fa-transgender',
				1799 => 'fa-solid fa-trash',
				1800 => 'fa-solid fa-trash-arrow-up',
				1801 => 'fa-solid fa-trash-can',
				1802 => 'fa-regular fa-trash-can',
				1803 => 'fa-solid fa-trash-can-arrow-up',
				1804 => 'fa-solid fa-tree',
				1805 => 'fa-solid fa-tree-city',
				1806 => 'fa-brands fa-trello',
				1807 => 'fa-solid fa-triangle-exclamation',
				1808 => 'fa-solid fa-trophy',
				1809 => 'fa-solid fa-trowel',
				1810 => 'fa-solid fa-trowel-bricks',
				1811 => 'fa-solid fa-truck',
				1812 => 'fa-solid fa-truck-arrow-right',
				1813 => 'fa-solid fa-truck-droplet',
				1814 => 'fa-solid fa-truck-fast',
				1815 => 'fa-solid fa-truck-field',
				1816 => 'fa-solid fa-truck-field-un',
				1817 => 'fa-solid fa-truck-front',
				1818 => 'fa-solid fa-truck-medical',
				1819 => 'fa-solid fa-truck-monster',
				1820 => 'fa-solid fa-truck-moving',
				1821 => 'fa-solid fa-truck-pickup',
				1822 => 'fa-solid fa-truck-plane',
				1823 => 'fa-solid fa-truck-ramp-box',
				1824 => 'fa-solid fa-tty',
				1825 => 'fa-brands fa-tumblr',
				1826 => 'fa-brands fa-tumblr-square',
				1827 => 'fa-solid fa-turkish-lira-sign',
				1828 => 'fa-solid fa-turn-down',
				1829 => 'fa-solid fa-turn-up',
				1830 => 'fa-solid fa-tv',
				1831 => 'fa-brands fa-twitch',
				1832 => 'fa-brands fa-twitter',
				1833 => 'fa-brands fa-twitter-square',
				1834 => 'fa-brands fa-typo3',
				1835 => 'fa-solid fa-u',
				1836 => 'fa-brands fa-uber',
				1837 => 'fa-brands fa-ubuntu',
				1838 => 'fa-brands fa-uikit',
				1839 => 'fa-brands fa-umbraco',
				1840 => 'fa-solid fa-umbrella',
				1841 => 'fa-solid fa-umbrella-beach',
				1842 => 'fa-brands fa-uncharted',
				1843 => 'fa-solid fa-underline',
				1844 => 'fa-brands fa-uniregistry',
				1845 => 'fa-brands fa-unity',
				1846 => 'fa-solid fa-universal-access',
				1847 => 'fa-solid fa-unlock',
				1848 => 'fa-solid fa-unlock-keyhole',
				1849 => 'fa-brands fa-unsplash',
				1850 => 'fa-brands fa-untappd',
				1851 => 'fa-solid fa-up-down',
				1852 => 'fa-solid fa-up-down-left-right',
				1853 => 'fa-solid fa-up-long',
				1854 => 'fa-solid fa-up-right-and-down-left-from-center',
				1855 => 'fa-solid fa-up-right-from-square',
				1856 => 'fa-solid fa-upload',
				1857 => 'fa-brands fa-ups',
				1858 => 'fa-brands fa-usb',
				1859 => 'fa-solid fa-user',
				1860 => 'fa-regular fa-user',
				1861 => 'fa-solid fa-user-astronaut',
				1862 => 'fa-solid fa-user-check',
				1863 => 'fa-solid fa-user-clock',
				1864 => 'fa-solid fa-user-doctor',
				1865 => 'fa-solid fa-user-gear',
				1866 => 'fa-solid fa-user-graduate',
				1867 => 'fa-solid fa-user-group',
				1868 => 'fa-solid fa-user-injured',
				1869 => 'fa-solid fa-user-large',
				1870 => 'fa-solid fa-user-large-slash',
				1871 => 'fa-solid fa-user-lock',
				1872 => 'fa-solid fa-user-minus',
				1873 => 'fa-solid fa-user-ninja',
				1874 => 'fa-solid fa-user-nurse',
				1875 => 'fa-solid fa-user-pen',
				1876 => 'fa-solid fa-user-plus',
				1877 => 'fa-solid fa-user-secret',
				1878 => 'fa-solid fa-user-shield',
				1879 => 'fa-solid fa-user-slash',
				1880 => 'fa-solid fa-user-tag',
				1881 => 'fa-solid fa-user-tie',
				1882 => 'fa-solid fa-user-xmark',
				1883 => 'fa-solid fa-users',
				1884 => 'fa-solid fa-users-between-lines',
				1885 => 'fa-solid fa-users-gear',
				1886 => 'fa-solid fa-users-line',
				1887 => 'fa-solid fa-users-rays',
				1888 => 'fa-solid fa-users-rectangle',
				1889 => 'fa-solid fa-users-slash',
				1890 => 'fa-solid fa-users-viewfinder',
				1891 => 'fa-brands fa-usps',
				1892 => 'fa-brands fa-ussunnah',
				1893 => 'fa-solid fa-utensils',
				1894 => 'fa-solid fa-v',
				1895 => 'fa-brands fa-vaadin',
				1896 => 'fa-solid fa-van-shuttle',
				1897 => 'fa-solid fa-vault',
				1898 => 'fa-solid fa-vector-square',
				1899 => 'fa-solid fa-venus',
				1900 => 'fa-solid fa-venus-double',
				1901 => 'fa-solid fa-venus-mars',
				1902 => 'fa-solid fa-vest',
				1903 => 'fa-solid fa-vest-patches',
				1904 => 'fa-brands fa-viacoin',
				1905 => 'fa-brands fa-viadeo',
				1906 => 'fa-brands fa-viadeo-square',
				1907 => 'fa-solid fa-vial',
				1908 => 'fa-solid fa-vial-circle-check',
				1909 => 'fa-solid fa-vial-virus',
				1910 => 'fa-solid fa-vials',
				1911 => 'fa-brands fa-viber',
				1912 => 'fa-solid fa-video',
				1913 => 'fa-solid fa-video-slash',
				1914 => 'fa-solid fa-vihara',
				1915 => 'fa-brands fa-vimeo',
				1916 => 'fa-brands fa-vimeo-square',
				1917 => 'fa-brands fa-vimeo-v',
				1918 => 'fa-brands fa-vine',
				1919 => 'fa-solid fa-virus',
				1920 => 'fa-solid fa-virus-covid',
				1921 => 'fa-solid fa-virus-covid-slash',
				1922 => 'fa-solid fa-virus-slash',
				1923 => 'fa-solid fa-viruses',
				1924 => 'fa-brands fa-vk',
				1925 => 'fa-brands fa-vnv',
				1926 => 'fa-solid fa-voicemail',
				1927 => 'fa-solid fa-volcano',
				1928 => 'fa-solid fa-volleyball',
				1929 => 'fa-solid fa-volume-high',
				1930 => 'fa-solid fa-volume-low',
				1931 => 'fa-solid fa-volume-off',
				1932 => 'fa-solid fa-volume-xmark',
				1933 => 'fa-solid fa-vr-cardboard',
				1934 => 'fa-brands fa-vuejs',
				1935 => 'fa-solid fa-w',
				1936 => 'fa-solid fa-walkie-talkie',
				1937 => 'fa-solid fa-wallet',
				1938 => 'fa-solid fa-wand-magic',
				1939 => 'fa-solid fa-wand-magic-sparkles',
				1940 => 'fa-solid fa-wand-sparkles',
				1941 => 'fa-solid fa-warehouse',
				1942 => 'fa-brands fa-watchman-monitoring',
				1943 => 'fa-solid fa-water',
				1944 => 'fa-solid fa-water-ladder',
				1945 => 'fa-solid fa-wave-square',
				1946 => 'fa-brands fa-waze',
				1947 => 'fa-brands fa-weebly',
				1948 => 'fa-brands fa-weibo',
				1949 => 'fa-solid fa-weight-hanging',
				1950 => 'fa-solid fa-weight-scale',
				1951 => 'fa-brands fa-weixin',
				1952 => 'fa-brands fa-whatsapp',
				1953 => 'fa-brands fa-whatsapp-square',
				1954 => 'fa-solid fa-wheat-awn',
				1955 => 'fa-solid fa-wheat-awn-circle-exclamation',
				1956 => 'fa-solid fa-wheelchair',
				1957 => 'fa-solid fa-wheelchair-move',
				1958 => 'fa-solid fa-whiskey-glass',
				1959 => 'fa-brands fa-whmcs',
				1960 => 'fa-solid fa-wifi',
				1961 => 'fa-brands fa-wikipedia-w',
				1962 => 'fa-solid fa-wind',
				1963 => 'fa-solid fa-window-maximize',
				1964 => 'fa-regular fa-window-maximize',
				1965 => 'fa-solid fa-window-minimize',
				1966 => 'fa-regular fa-window-minimize',
				1967 => 'fa-solid fa-window-restore',
				1968 => 'fa-regular fa-window-restore',
				1969 => 'fa-brands fa-windows',
				1970 => 'fa-solid fa-wine-bottle',
				1971 => 'fa-solid fa-wine-glass',
				1972 => 'fa-solid fa-wine-glass-empty',
				1973 => 'fa-brands fa-wirsindhandwerk',
				1974 => 'fa-brands fa-wix',
				1975 => 'fa-brands fa-wizards-of-the-coast',
				1976 => 'fa-brands fa-wodu',
				1977 => 'fa-brands fa-wolf-pack-battalion',
				1978 => 'fa-solid fa-won-sign',
				1979 => 'fa-brands fa-wordpress',
				1980 => 'fa-brands fa-wordpress-simple',
				1981 => 'fa-solid fa-worm',
				1982 => 'fa-brands fa-wpbeginner',
				1983 => 'fa-brands fa-wpexplorer',
				1984 => 'fa-brands fa-wpforms',
				1985 => 'fa-brands fa-wpressr',
				1986 => 'fa-solid fa-wrench',
				1987 => 'fa-solid fa-x',
				1988 => 'fa-solid fa-x-ray',
				1989 => 'fa-brands fa-xbox',
				1990 => 'fa-brands fa-xing',
				1991 => 'fa-brands fa-xing-square',
				1992 => 'fa-solid fa-xmark',
				1993 => 'fa-solid fa-xmarks-lines',
				1994 => 'fa-solid fa-y',
				1995 => 'fa-brands fa-y-combinator',
				1996 => 'fa-brands fa-yahoo',
				1997 => 'fa-brands fa-yammer',
				1998 => 'fa-brands fa-yandex',
				1999 => 'fa-brands fa-yandex-international',
				2000 => 'fa-brands fa-yarn',
				2001 => 'fa-brands fa-yelp',
				2002 => 'fa-solid fa-yen-sign',
				2003 => 'fa-solid fa-yin-yang',
				2004 => 'fa-brands fa-yoast',
				2005 => 'fa-brands fa-youtube',
				2006 => 'fa-brands fa-youtube-square',
				2007 => 'fa-solid fa-z',
				2008 => 'fa-brands fa-zhihu',
			);
	}
}
