<?php
namespace Mewz\WCAS\Actions\Front;

use Mewz\Framework\Base\Action;
use Mewz\WCAS\Util\Settings;

class ProductDisplay extends Action
{
	public function __hooks()
	{
		$outofstock_variations = Settings::outofstock_variations();
		$ajax_variation_threshold = Settings::ajax_variation_threshold();

		if ($outofstock_variations === 'greyedout') {
			add_filter('woocommerce_variation_is_active', [$this, 'variation_is_active'], 10, 2);
		} elseif ($outofstock_variations === 'hidden') {
			add_filter('woocommerce_variation_is_visible', [$this, 'variation_is_visible'], 10, 4);
		}

		if ($ajax_variation_threshold !== '' && is_numeric($ajax_variation_threshold)) {
			add_filter('woocommerce_ajax_variation_threshold', [$this, 'ajax_variation_threshold'], -10, 2);
		}
	}

	public function variation_is_active($value, $variation)
	{
		return $variation->is_in_stock() ? $value : false;
	}

	public function variation_is_visible($value, $variation_id, $parent_id, $variation)
	{
		return $variation->is_in_stock() ? $value : false;
	}

	public function ajax_variation_threshold($default)
	{
		$value = Settings::ajax_variation_threshold(true);

	    return $value === '' ? $default : (int)$value;
	}
}
