<?php
defined('ABSPATH') or die;

/**
 * @var Mewz\Framework\Services\View $this
 * @var \WC_Product $product
 */
?>

<div class="mewz-wcas-options options_group show_if_simple show_if_variable">

<?php woocommerce_wp_checkbox([
	'id' => '_mewz_wcas_exclude',
	'value' => (int)$product->get_meta('_mewz_wcas_exclude'),
	'cbvalue' => 1,
	'label' => __('Ignore attribute stock', 'woocommerce-attribute-stock'),
	'description' => __('Exclude this product from affecting or being affected by attribute stock', 'woocommerce-attribute-stock'),
]); ?>

<?php woocommerce_wp_text_input([
	'id' => '_mewz_wcas_multiplier',
	'value' => $product->get_meta('_mewz_wcas_multiplier'),
	'label' => __('Attribute stock multiplier', 'woocommerce-attribute-stock'),
	'desc_tip' => true,
	'description' => __('Override the quantity multiplier of any matched attribute stock groups for this product. Variation level setting takes priority.', 'woocommerce-attribute-stock'),
	'type' => 'number',
	'custom_attributes' => [
		'step' => 'any',
		'min' => '0',
	],
]); ?>

</div>
