<?php
namespace Mewz\WCAS\Aspects\Common;

use Mewz\Framework\Base\Aspect;
use Mewz\WCAS\Util\Products;
use Mewz\WCAS\Util\Settings;

class ProductSettings extends Aspect
{
	public function __hooks()
	{
		add_action('woocommerce_before_product_object_save', [Products::class, 'validate_stock_props'], 0, 2);

		if (Settings::product_stock_format() !== '') {
			add_action('init', [$this, 'init_stock_amount'], 20);
		}

		if ($this->context->front) {
			$outofstock_variations = Settings::outofstock_variations();
			$ajax_variation_threshold = Settings::ajax_variation_threshold();

			if ($outofstock_variations === 'greyedout') {
				add_filter('woocommerce_variation_is_active', [$this, 'variation_is_active'], 10, 2);
			} elseif ($outofstock_variations === 'hidden') {
				add_filter('woocommerce_variation_is_visible', [$this, 'variation_is_visible'], 10, 4);
			}

			if ($ajax_variation_threshold !== '' && is_numeric($ajax_variation_threshold)) {
				add_filter('woocommerce_ajax_variation_threshold', [$this, 'ajax_variation_threshold'], -10, 2);
			}
		}
	}

	public function init_stock_amount()
	{
		$stock_format = Settings::product_stock_format();

		if (!in_array($stock_format, ['decimal', 'decimal_whole'])) {
			return;
		}

		remove_filter('woocommerce_stock_amount', 'intval');
		add_filter('woocommerce_stock_amount', 'floatval', 0);

		if ($stock_format === 'decimal_whole' && $this->context->front) {
			add_filter('woocommerce_format_stock_quantity', 'intval', 0);
		}
	}

	public function variation_is_active($value, $variation)
	{
		return $variation->is_in_stock() ? $value : false;
	}

	public function variation_is_visible($value, $variation_id, $parent_id, $variation)
	{
		return $variation->is_in_stock() ? $value : false;
	}

	public function ajax_variation_threshold($default)
	{
		$value = Settings::ajax_variation_threshold(true);

	    return $value === '' ? $default : (int)$value;
	}
}
