<?php
defined('ABSPATH') or die;

/**
 * @var Mewz\WCAS\Models\AttributeStock $stock
 * @var string $type
 * @var string $class
 * @var array $pills
 * @var bool $wrap
 * @var int $show_max
 * @var int $collapsed_max
 */

if (empty($pills)) {
	return;
}

$wrap ??= true;
$class = !empty($class) ? " $class" : '';
$show_max ??= 3;
$show_collapsed ??= max(1, $show_max - 1);
$total_pills = count($pills);
$n = 0;
?>

<?php if ($wrap): ?>
	<div class="mewz-wcas-pills">
<?php endif; ?>

<?php foreach ($pills as $pill): ?>

	<?= !empty($pill['url']) ? '<a href="' . esc_url($pill['url']) . '"' : '<span' ?> class="mewz-wcas-pill mewz-wcas-pill-<?= $type . $class; ?>"<?= isset($pill['title']) ? ' title="' . esc_attr($pill['title']) . '"' : '' ?>><?php

		if (isset($pill['label'])) {
			echo '<span class="pill-label">' . esc_html($pill['label']) . '<span class="hidden-text">: </span></span>';
		}

		echo esc_html($pill['value']);

		if (isset($pill['meta']) && strlen($pill['meta'])) {
			echo ' <span class="pill-meta">' . esc_html($pill['meta']) . '</span>';
		}

	?><?= !empty($pill['url']) ? '</a>' : '</span>' ?>

	<?php if ($total_pills > $show_max && ++$n == $show_collapsed): ?>
		<button type="button" class="mewz-wcas-pill show-more" data-show="<?= $type ?>" title="<?= esc_attr__('Show more', 'woocommerce-attribute-stock') ?>">+<?= $total_pills - $n ?></button>
		<?php $class .= ' hidden'; ?>
	<?php endif; ?>

<?php endforeach; ?>

<?php if ($wrap): ?>
	</div>
<?php endif; ?>
