<?php
/**
 * Plugin Name: WP Overnight Sidekick
 * Plugin URI:  https://wpovernight.com/
 * Description: WP Overnight Sidekick is an administration plugin for all your WP Overnight Purchases. All WP Overnight themes and plugins will be managed via this plugin.
 * Version:     2.5.1
 * Author:      WP Overnight
 * Author URI:  https://wpovernight.com
 * License:     GPLv2 or later
 * License URI: https://opensource.org/licenses/gpl-license.php
 * Text Domain: wpovernight-sidekick
 * Domain Path: /languages
 */

class WPOvernight_Core {
	
	// Setup Variables
	public $version = '2.5.1';
	public $main_menu_hook;
	public $get_new_hook;
	public $options_page_hook;
	public $settings;
	public $options;

	public function __construct() {
		if ( ! defined( 'WPO_SIDEKICK_PLUGIN_BASENAME' ) ) {
			define( 'WPO_SIDEKICK_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		}
		// load textdomain
		add_action( 'init', array( $this, 'load_textdomain' ) );
				
		$this->includes();
		$this->settings = new WPOCore_Settings();
		$this->options  = get_option( 'wpocore-license' );

		// Init updater data
		$item_name    = 'WP Overnight Sidekick';
		$file         = __FILE__;
		$license_slug = 'wpo_core_license';
		$author       = 'Jeremiah Prummer';

		new WPO_Updater( $item_name, $file, $license_slug, $this->version, $author );

		add_action( 'admin_menu', array( $this, 'wpo_core_menu' ), 99 );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_scripts_styles' ) ); // Load scripts

		if ( ! defined( 'WPO_SIDEKICK_VERSION' ) ) {
			define( 'WPO_SIDEKICK_VERSION', $this->version );
		}
	}

	/**
	 * Load plugin text domain
	 */
	public function load_textdomain() 	{
		load_plugin_textdomain( 'wpovernight-sidekick', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}
	
	/**
	 * Load additional classes and functions
	 */
	public function includes() {
		require_once( 'includes/wpo-core-settings.php' );
		require_once( 'includes/wpo-core-updater.php' );
	}

	/** 
	* Add Menu Page 
	*/
	public function wpo_core_menu() {
		if ( apply_filters( 'wpo_license_management_enabled', true ) ) {
			$parent = apply_filters( 'wpo_license_management_parent_menu_slug', 'wpo-core-menu' );
			if ( $parent == 'wpo-core-menu' ) {
				$this->main_menu_hook = add_menu_page(
					'WP Overnight Core',
					'WP Overnight', 
					'manage_options', 
					'wpo-core-menu', 
					array( $this, 'wpo_core_page' ), 
					'', 
					65
				);
			}
		}
	}
	
	/** 
	* Main Page 
	*/
	public function wpo_core_page() {
		if ( !current_user_can( 'manage_options' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.', 'wpovernight-sidekick' ) );
		}

		?>
		<div class="wrap">
			<div class="wpocore-main-page">
				<h1><?php _e( 'Say Hello to Your WP Overnight Sidekick!', 'wpovernight-sidekick' ); ?></h1>
				<p><?php /* translators: 1,2. <a> tags */
					printf( __( 'With the WP Overnight Sidekick plugin you are always up to date with all our plugins. If you enter your license key in the %1$sManage Licenses%2$s section, the plugin will regularly check for updates and notify you of new releases.', 'wpovernight-sidekick' ), '<a href="?page=wpo-license-page">', '</a>'); ?></p>
				<p><?php /* translators: 1,2. <a> tags */
					printf( __( 'On our website %1$swpovernight.com%2$s you can find all other plugins and extensions we offer.', 'wpovernight-sidekick' ), '<a href="https://wpovernight.com/shop/">', '</a>' ); ?></p>
				<p><?php /* translators: 1-4. <a> tags */
					printf( __( 'Need help? %1$sCheck out our documentation%2$s or send us an email to %1$ssupport@wpovernight.com%2$s and we will get back to you as soon as possible.', 'wpovernight-sidekick' ), '<a href="https://docs.wpovernight.com" target="blank">', '</a>', '<a href="mailto:support@wpovernight.com">', '</a>' ); ?></p>
			</div>

		<?php 

		// Include available plugins
		$rss = fetch_feed( apply_filters( 'wpovernight_store_url', 'https://wpovernight.com' ) . '/feed/?post_type=download' );
		if ( is_wp_error( $rss ) ) {
			return;
		}
		?>
			<div class="wpocore-plugin-page">
				<h1><?php _e( 'Check out our other plugins!', 'wpovernight-sidekick' ); ?></h1>
				<ul class="wpo-plugin-shop">
					<?php
					// Loop through each feed item and display each item as a hyperlink.
					foreach ( $rss->get_items() as $item ) :
						$classname = $item->get_item_tags( '', 'ClassName' );
						$class     = ! empty( $classname[0]['data'] ) ? $classname[0]['data'] : '';
						// echo $class;
						if ( class_exists( $class ) ){
							$item_class = 'installed';
						} else {
							$item_class = 'not-installed';
						}
						?>
						<li class="<?php echo $item_class; ?>">	
							<a href="<?php echo $item->get_permalink(); ?>?utm_source=sidekick&utm_medium=sidekick&utm_campaign=<?php echo urlencode($item->get_title()); ?>" title="<?php echo 'Posted '.$item->get_date('j F Y | g:i a'); ?>" class="wpo-feed-header">
							<?php echo $item->get_title(); ?></a>
							<?php echo $item->get_description(); ?>
							<a href="<?php echo $item->get_link(); ?>?utm_source=sidekick&utm_medium=sidekick&utm_campaign=<?php echo urlencode($item->get_title()); ?>" class="wpo-read-more"><?php _e( 'Read more', 'wpovernight-sidekick' ); ?>&rarr;</a>
						</li>
					<?php endforeach; ?>
				</ul>
		
			</div>
		</div>

	<?php } 
	
	/**
	 * Load CSS (and/or scripts)
	 */
	public function load_scripts_styles ( $hook ) {
		global $wp_version;
		
		if( $hook != $this->settings->options_page_hook && $hook != $this->main_menu_hook && $hook != $this->get_new_hook ) {
			return;
		}
		wp_register_style( 'wpovernight-core', plugins_url( '/css/wpovernight-core.css', __FILE__ ), array(), '', 'all' );
		wp_enqueue_style( 'wpovernight-core' );
	}

	/** 
	* Get Plugins Page 
	*/
	public function wpo_plugins_page() {
		if ( !current_user_can( 'manage_options' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.', 'wpovernight-sidekick' ) );
		}
		echo '<div class="wrap">';
		?>
		<?php include_once(ABSPATH.WPINC.'/feed.php');
			
			$rss = fetch_feed( apply_filters( 'wpovernight_store_url', 'https://wpovernight.com' ) . '/feed/?post_type=download' );
		?>
			<ul class="wpo-plugin-shop">
		<?php
		
			// Loop through each feed item and display each item as a hyperlink.
			foreach ( $rss->get_items() as $item ) :
			$classname = $item->get_item_tags('', 'ClassName');
			$class = $classname[0]['data'];
			echo $class;
			if(class_exists($class)){
				$item_class = 'installed';
			} else {
				$item_class = 'not-installed';
			}
		?>
			<li class="<?php echo $item_class; ?>">	
			<a href="<?php echo $item->get_permalink(); ?>?utm_source=sidekick&utm_medium=sidekick&utm_campaign=<?php echo urlencode($item->get_title()); ?>" title="<?php echo 'Posted '.$item->get_date('j F Y | g:i a'); ?>" class="wpo-feed-header">
			<?php echo $item->get_title(); ?></a>
			<?php echo $item->get_description(); ?>
			<a href="<?php echo $item->get_link(); ?>?utm_source=sidekick&utm_medium=sidekick&utm_campaign=<?php echo urlencode($item->get_title()); ?>" class="wpo-read-more"><?php _e( 'Read more', 'wpovernight-sidekick' ); ?>&rarr;</a>
			</li>
			<?php endforeach; ?>
			</ul>
		<?php
		echo '</div>';
	}
}
$WPO_Core = new WPOvernight_Core();
