<?php

defined( 'ABSPATH' ) or exit;

?>
<div id="pwgc-section-balances" class="pwgc-section" style="<?php pwgc_dashboard_helper( 'balances', 'display: block;' ); ?>">
    <div id="pwgc-balance-summary-container">
        <?php
            require_once( 'balance-summary.php' );
        ?>
    </div>

    <form id="pwgc-balance-search-form">
        <?php
            $selected_variation_ids = isset( $_REQUEST['variation_ids'] ) ? explode( ',', $_REQUEST['variation_ids'] ) : array();
            $products = pwgc_get_all_gift_card_products();
            if ( !empty( $products ) ) {
                ?>
                <div class="pwgc-summary-product-filter <?php echo ( 'yes' !== get_option( 'pwgc_show_balances_by_product', 'no' ) ) ? 'pwgc-hidden' : ''; ?>">
                    <select id="pwgc-balance-search-variation-ids" name="variation_ids" multiple>
                        <option value="" <?php selected( empty( $selected_variation_ids ) ); ?>><?php esc_html_e( 'All Gift Card Products', 'pw-woocommerce-gift-cards' ); ?></option>
                        <?php
                            foreach ( $products as $product ) {
                                foreach ( $product->get_children() as $variation_id ) {
                                    $variation = wc_get_product( $variation_id );
                                    if ( is_a( $variation, 'WC_Product_Variation' ) ) {
                                        $variation_name = $variation->get_name();
                                        if ( PWGC_SHOW_SKU_IN_VARIATION_NAME ) {
                                            if ( $variation->get_sku() ) {
                                                $identifier = $variation->get_sku();
                                            } else {
                                                $identifier = '#' . $variation->get_id();
                                            }
                                            $variation_name = sprintf( '%2$s (%1$s)', $identifier, $variation->get_name() );
                                        }

                                        ?>
                                        <option value="<?php echo $variation_id; ?>" <?php selected( in_array( $variation_id, $selected_variation_ids ) ); ?>><?php esc_html_e( $variation_name ); ?></option>
                                        <?php
                                    }
                                }
                            }
                        ?>
                    </select>
                </div>
                <?php
            }
        ?>

        <input type="text" id="pwgc-balance-search" name="card_number" autocomplete="off" placeholder="<?php _e( 'Gift card number or recipient email (leave blank for all)', 'pw-woocommerce-gift-cards' ); ?>" value="<?php echo isset( $_GET['card_number'] ) ? esc_html( stripslashes( $_GET['card_number'] ) ) : ''; ?>">
        <input type="submit" id="pwgc-balance-search-button" class="button button-primary" value="<?php _e( 'Search', 'pw-woocommerce-gift-cards' ); ?>">
    </form>

    <div id="pwgc-balance-main-container">
        <div id="pwgc-balance-search-results"></div>
    </div>
</div>
